/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.CryoChamberTileEntity;
import iskallia.vault.client.ClientEternalData;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.widget.TooltipImageButton;
import iskallia.vault.config.EternalAuraConfig;
import iskallia.vault.config.entry.FloatRangeEntry;
import iskallia.vault.container.inventory.CryochamberContainer;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.entity.eternal.EternalHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModShaders;
import iskallia.vault.network.message.EternalInteractionMessage;
import iskallia.vault.network.message.ServerboundRenameEternalMessage;
import iskallia.vault.network.message.ServerboundToggleEternalPlayerSkinMessage;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CryochamberScreen
extends AbstractContainerScreen<CryochamberContainer> {
    private static final DecimalFormat ATTRIBUTE_FORMAT = new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private static final DecimalFormat ATTRIBUTE_MS_FORMAT = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private static final ResourceLocation TEXTURE = VaultMod.id("textures/gui/cryochamber_inventory.png");
    private EternalDataSnapshot prevSnapshot = null;
    private EternalEntity eternalSkinCache = null;

    public CryochamberScreen(CryochamberContainer screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 211;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97728_ = 19;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.m_169413_();
        EternalDataSnapshot snapshot = this.getEternal();
        if (snapshot == null) {
            return;
        }
        if (snapshot.getUsedLevels() < snapshot.getLevel()) {
            int offsetX = this.f_97735_ + 78;
            int yOffset = 0;
            int yShift = 16;
            this.m_142416_((GuiEventListener)new ImageButton(offsetX, this.f_97736_ + 18, 16, 16, 176, yOffset, yShift, TEXTURE, 256, 256, btn -> {
                if (snapshot.getUsedLevels() >= snapshot.getLevel()) {
                    return;
                }
                ModNetwork.CHANNEL.sendToServer((Object)EternalInteractionMessage.levelUp("health"));
            }, (btn, matrixStack, mouseX, mouseY) -> this.renderAttributeHoverTooltip(ModConfigs.ETERNAL_ATTRIBUTES.getHealthRollRange(), 1.0f, ATTRIBUTE_FORMAT, matrixStack, mouseX, mouseY), TextComponent.f_131282_));
            this.m_142416_((GuiEventListener)new ImageButton(offsetX, this.f_97736_ + 36, 16, 16, 176, yOffset, yShift, TEXTURE, 256, 256, btn -> {
                if (snapshot.getUsedLevels() >= snapshot.getLevel()) {
                    return;
                }
                ModNetwork.CHANNEL.sendToServer((Object)EternalInteractionMessage.levelUp("damage"));
            }, (btn, matrixStack, mouseX, mouseY) -> this.renderAttributeHoverTooltip(ModConfigs.ETERNAL_ATTRIBUTES.getDamageRollRange(), 1.0f, ATTRIBUTE_FORMAT, matrixStack, mouseX, mouseY), TextComponent.f_131282_));
            this.m_142416_((GuiEventListener)new ImageButton(offsetX, this.f_97736_ + 54, 16, 16, 176, yOffset, yShift, TEXTURE, 256, 256, btn -> {
                if (snapshot.getUsedLevels() >= snapshot.getLevel()) {
                    return;
                }
                ModNetwork.CHANNEL.sendToServer((Object)EternalInteractionMessage.levelUp("movespeed"));
            }, (btn, matrixStack, mouseX, mouseY) -> this.renderAttributeHoverTooltip(ModConfigs.ETERNAL_ATTRIBUTES.getMoveSpeedRollRange(), 10.0f, ATTRIBUTE_MS_FORMAT, matrixStack, mouseX, mouseY), TextComponent.f_131282_));
        }
        if (snapshot.getAbilityName() == null) {
            List<EternalAuraConfig.AuraConfig> options = ModConfigs.ETERNAL_AURAS.getRandom(snapshot.getSeededRand(), 3);
            int abilityX = this.f_97735_ + 8;
            int abilityY = this.f_97736_ + 90;
            for (EternalAuraConfig.AuraConfig abilityOption : options) {
                this.m_142416_((GuiEventListener)new TooltipImageButton(abilityX, abilityY, 24, 24, 192, 0, 24, TEXTURE, 256, 256, btn -> ModNetwork.CHANNEL.sendToServer((Object)EternalInteractionMessage.selectEffect(abilityOption.getName()))));
                abilityX += 30;
            }
        }
    }

    private void renderAttributeHoverTooltip(FloatRangeEntry range, float multiplier, DecimalFormat format, PoseStack matrixStack, int mouseX, int mouseY) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 300.0);
        String min = format.format(range.getMin() * multiplier);
        String max = format.format(range.getMax() * multiplier);
        TextComponent txt = new TextComponent("Adds +" + min + " to +" + max);
        this.renderTooltip(matrixStack, List.of(txt.m_7532_()), mouseX, mouseY, this.f_96547_);
        matrixStack.m_85849_();
    }

    public void m_181908_() {
        super.m_181908_();
        EternalDataSnapshot snapshot = this.getEternal();
        if (snapshot == null) {
            return;
        }
        if (this.prevSnapshot == null || !this.prevSnapshot.areStatisticsEqual(snapshot)) {
            this.prevSnapshot = snapshot;
            this.refreshButtons();
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int offsetX = (this.f_96543_ - this.f_97726_) / 2;
        int offsetY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, offsetX, offsetY, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        EternalDataSnapshot snapshot = this.getEternal();
        if (snapshot == null) {
            return;
        }
        if (this.eternalSkinCache == null) {
            this.eternalSkinCache = EternalHelper.spawnEternal((Level)Minecraft.m_91087_().f_91073_, snapshot);
            this.eternalSkinCache.skin.updateSkin(snapshot.getName());
            Arrays.stream(EquipmentSlot.values()).forEach(slot -> this.eternalSkinCache.m_8061_((EquipmentSlot)slot, ItemStack.f_41583_));
            this.eternalSkinCache.m_20340_(false);
        }
        if (snapshot.isAncient()) {
            FontHelper.drawStringWithBorder(matrixStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 15910161, 0x404040);
        } else {
            this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        }
        this.f_96547_.m_92889_(matrixStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
        this.renderEternal(snapshot, matrixStack, mouseX, mouseY);
        RenderSystem.m_69482_();
        this.renderLevel(snapshot, matrixStack);
        this.renderAttributeDisplay(snapshot, matrixStack);
        this.renderAbility(snapshot, matrixStack, mouseX, mouseY);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        boolean isHovered = this.f_97735_ + 5 <= mouseX && mouseX <= this.f_97735_ + 5 + 11 && this.f_97736_ + 5 <= mouseY && mouseY <= this.f_97736_ + 5 + 11;
        this.m_93228_(matrixStack, 5, 5, 179, isHovered ? 82 : 66, 11, 11);
        boolean bl = isHovered = this.f_97735_ + 100 <= mouseX && mouseX <= this.f_97735_ + 100 + 11 && this.f_97736_ + 26 <= mouseY && mouseY <= this.f_97736_ + 26 + 11;
        if (isHovered) {
            this.m_93228_(matrixStack, 100, 26, 178, 97, 13, 13);
        }
        this.m_93228_(matrixStack, 101, 27, 179, snapshot.isUsingPlayerSkin() ? 50 : 34, 11, 11);
    }

    private void renderAbility(EternalDataSnapshot snapshot, PoseStack matrixStack, int mouseX, int mouseY) {
        if (snapshot.getAbilityName() == null) {
            List<EternalAuraConfig.AuraConfig> options = ModConfigs.ETERNAL_AURAS.getRandom(snapshot.getSeededRand(), 3);
            int abilityX = 12;
            int abilityY = 94;
            for (EternalAuraConfig.AuraConfig abilityOption : options) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(abilityOption.getIconPath()));
                CryochamberScreen.m_93133_((PoseStack)matrixStack, (int)abilityX, (int)abilityY, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
                abilityX += 30;
            }
            abilityX = 8;
            abilityY = 90;
            for (EternalAuraConfig.AuraConfig abilityOption : options) {
                Rectangle box = new Rectangle(abilityX, abilityY, 24, 24);
                if (box.contains(mouseX - this.f_97735_, mouseY - this.f_97736_)) {
                    this.m_96597_(matrixStack, abilityOption.getTooltip(), mouseX - this.f_97735_, mouseY - this.f_97736_);
                }
                abilityX += 30;
            }
        } else {
            EternalAuraConfig.AuraConfig cfg = ModConfigs.ETERNAL_AURAS.getByName(snapshot.getAbilityName());
            if (cfg == null) {
                return;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(cfg.getIconPath()));
            CryochamberScreen.m_93133_((PoseStack)matrixStack, (int)8, (int)92, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            matrixStack.m_85836_();
            matrixStack.m_85837_(26.0, 92.0, 0.0);
            matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
            UIHelper.renderWrappedText(matrixStack, (Component)new TextComponent(cfg.getDescription()), 82, 0, 0x404040);
            matrixStack.m_85849_();
        }
    }

    private void renderAttributeDisplay(EternalDataSnapshot snapshot, PoseStack matrixStack) {
        String healthStr = ATTRIBUTE_FORMAT.format(snapshot.getEntityAttributes().get(Attributes.f_22276_));
        this.renderAttributeStats(matrixStack, "Health:", healthStr, 18, 32);
        String damageStr = ATTRIBUTE_FORMAT.format(snapshot.getEntityAttributes().get(Attributes.f_22281_));
        this.renderAttributeStats(matrixStack, "Damage:", damageStr, 36, 48);
        String speedStr = ATTRIBUTE_MS_FORMAT.format(snapshot.getEntityAttributes().get(Attributes.f_22279_).floatValue() * 10.0f);
        this.renderAttributeStats(matrixStack, "Speed:", speedStr, 54, 64);
        int availableLevels = Math.max(snapshot.getLevel() - snapshot.getUsedLevels(), 0);
        if (availableLevels > 0) {
            String display = String.valueOf(availableLevels);
            int offsetX = this.f_96547_.m_92895_(display) / 2;
            matrixStack.m_85836_();
            matrixStack.m_85837_(86.0, 13.0, 0.0);
            matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
            matrixStack.m_85837_((double)(-offsetX), 0.0, 0.0);
            this.f_96547_.m_92883_(matrixStack, display, 0.0f, 0.0f, 0x404040);
            matrixStack.m_85849_();
        }
        String resistPercent = PERCENT_FORMAT.format(snapshot.getResistance() * 100.0f) + "%";
        String armorAmount = PERCENT_FORMAT.format(EternalHelper.getEternalGearModifierAdjustments(snapshot, Attributes.f_22284_, 0.0f));
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrixStack, 8, 72, 216, 16, 16, 16);
        matrixStack.m_85836_();
        matrixStack.m_85837_(24.0, 72.0, 0.0);
        matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
        this.f_96547_.m_92883_(matrixStack, resistPercent, 0.0f, 5.0f, 0x404040);
        matrixStack.m_85849_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrixStack, 39, 72, 216, 80, 16, 16);
        matrixStack.m_85836_();
        matrixStack.m_85837_(55.0, 72.0, 0.0);
        matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
        this.f_96547_.m_92883_(matrixStack, armorAmount, 0.0f, 5.0f, 0x404040);
        matrixStack.m_85849_();
    }

    private void renderAttributeStats(PoseStack matrixStack, String description, String valueStr, int offsetY, int vOffset) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrixStack, 8, offsetY, 216, vOffset, 16, 16);
        matrixStack.m_85836_();
        matrixStack.m_85837_(26.0, (double)(offsetY + 6), 0.0);
        matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
        this.f_96547_.m_92883_(matrixStack, description, 0.0f, 0.0f, 0x404040);
        matrixStack.m_85849_();
        float xShift = (float)this.f_96547_.m_92895_(valueStr) * 0.8f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(73.0, (double)(offsetY + 6), 0.0);
        matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
        matrixStack.m_85837_((double)(-xShift), 0.0, 0.0);
        this.f_96547_.m_92883_(matrixStack, valueStr, 0.0f, 0.0f, 0x404040);
        matrixStack.m_85849_();
    }

    private void renderLevel(EternalDataSnapshot snapshot, PoseStack matrixStack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int levelPart = Mth.m_14143_((float)(snapshot.getLevelPercent() * 62.0f));
        this.m_93228_(matrixStack, 103, 17, 0, 212, 62, 5);
        this.m_93228_(matrixStack, 103, 17, 0, 218, levelPart, 5);
        String lvlStr = snapshot.getLevel() + " / " + snapshot.getMaxLevel();
        float x = 136.0f - (float)this.f_96547_.m_92895_(lvlStr) / 2.0f;
        int y = 12;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_(0.8f, 0.8f, 1.0f);
        FontHelper.drawStringWithBorder(matrixStack, lvlStr, 0.0f, 0.0f, -6601, -12698050);
        matrixStack.m_85849_();
    }

    private void renderEternal(EternalDataSnapshot snapshot, PoseStack matrixStack, int mouseX, int mouseY) {
        int width;
        Rectangle feedRct;
        int offsetX = 125;
        int offsetY = 105;
        if (!snapshot.isAlive()) {
            ModShaders.getGrayscalePositionTexShader().withGrayscale(0.0f).withBrightness(1.0f).enable();
        }
        int lookX = this.f_97735_ - mouseX + offsetX;
        int lookY = this.f_97736_ - mouseY + offsetY;
        if (!snapshot.isAlive()) {
            lookX = 0;
            lookY = -30;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)offsetX, (double)offsetY, 0.0);
        if (!snapshot.isAncient()) {
            matrixStack.m_85841_(1.2f, 1.2f, 1.2f);
        }
        UIHelper.drawFacingEntity((LivingEntity)this.eternalSkinCache, matrixStack, lookX, lookY - 50);
        Lighting.m_84931_();
        matrixStack.m_85849_();
        ItemStack heldStack = ((CryochamberContainer)this.f_97732_).m_142621_();
        if (!heldStack.m_41619_() && EternalInteractionMessage.canBeFed(snapshot, heldStack) && (feedRct = new Rectangle(99, 25, 51, 90)).contains(mouseX - this.f_97735_, mouseY - this.f_97736_)) {
            this.m_96602_(matrixStack, (Component)new TextComponent("Give to " + this.f_96539_.getString()), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (!snapshot.isAlive()) {
            String deadTxt = "Unalived";
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 600.0);
            width = this.f_96547_.m_92895_(deadTxt);
            FontHelper.drawStringWithBorder(matrixStack, deadTxt, 125.0f - (float)width / 2.0f, 100.0f, 0xFF3030, 0);
            matrixStack.m_85849_();
        }
        if (snapshot.isAncient()) {
            String ancientTxt = "Ancient";
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 600.0);
            width = this.f_96547_.m_92895_(ancientTxt);
            FontHelper.drawStringWithBorder(matrixStack, ancientTxt, 125.0f - (float)width / 2.0f, 28.0f, 15910161, 0);
            matrixStack.m_85849_();
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        ItemStack heldStack;
        super.m_6375_(mouseX, mouseY, button);
        if (button != 0) {
            return false;
        }
        EternalDataSnapshot snapshot = this.getEternal();
        if (snapshot == null) {
            return false;
        }
        if ((double)(this.f_97735_ + 5) <= mouseX && mouseX <= (double)(this.f_97735_ + 5 + 11) && (double)(this.f_97736_ + 5) <= mouseY && mouseY <= (double)(this.f_97736_ + 5 + 11)) {
            ServerboundRenameEternalMessage.send(((CryochamberContainer)this.f_97732_).getTilePos());
        }
        if ((double)(this.f_97735_ + 101) <= mouseX && mouseX <= (double)(this.f_97735_ + 101 + 11) && (double)(this.f_97736_ + 27) <= mouseY && mouseY <= (double)(this.f_97736_ + 27 + 11)) {
            ServerboundToggleEternalPlayerSkinMessage.send(((CryochamberContainer)this.f_97732_).getTilePos());
            this.eternalSkinCache = null;
            this.prevSnapshot = null;
        }
        if ((heldStack = ((CryochamberContainer)this.f_97732_).m_142621_()).m_41619_() || !EternalInteractionMessage.canBeFed(snapshot, heldStack)) {
            return false;
        }
        Rectangle feedRct = new Rectangle(99, 25, 51, 90);
        if (!feedRct.contains(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_)) {
            return false;
        }
        ModNetwork.CHANNEL.sendToServer((Object)EternalInteractionMessage.feedItem(heldStack));
        if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
            heldStack.m_41774_(1);
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    @Nullable
    private EternalDataSnapshot getEternal() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return null;
        }
        CryoChamberTileEntity tile = ((CryochamberContainer)this.f_97732_).getCryoChamber((Level)world);
        if (tile == null) {
            return null;
        }
        return ClientEternalData.getSnapshot(tile.getEternalId());
    }
}

