/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.client.gui.widget.AbilitySelectionWidget;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.network.message.ServerboundAbilitySelectMessage;
import iskallia.vault.skill.ability.AbilityNode;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class AbilitySelectionScreen
extends Screen {
    public static final ResourceLocation HUD_RESOURCE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");

    public AbilitySelectionScreen() {
        super((Component)new TextComponent(""));
    }

    public List<AbilitySelectionWidget> getAbilitiesAsWidgets() {
        LinkedList<AbilitySelectionWidget> abilityWidgets = new LinkedList<AbilitySelectionWidget>();
        Minecraft minecraft = Minecraft.m_91087_();
        float midX = (float)minecraft.m_91268_().m_85445_() / 2.0f;
        float midY = (float)minecraft.m_91268_().m_85446_() / 2.0f;
        float radius = 60.0f;
        List<AbilityNode<?, ?>> learnedAbilities = ClientAbilityData.getLearnedAbilityNodes();
        double clickableAngle = Math.PI * 2 / (double)learnedAbilities.size();
        for (int i = 0; i < learnedAbilities.size(); ++i) {
            AbilityNode<?, ?> ability = learnedAbilities.get(i);
            double angle = (double)i * (Math.PI * 2 / (double)learnedAbilities.size()) - 1.5707963267948966;
            double x = (double)radius * Math.cos(angle) + (double)midX;
            double y = (double)radius * Math.sin(angle) + (double)midY;
            AbilitySelectionWidget widget = new AbilitySelectionWidget((int)x, (int)y, ability, clickableAngle / 2.0);
            abilityWidgets.add(widget);
        }
        return abilityWidgets;
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (AbilitySelectionWidget widget : this.getAbilitiesAsWidgets()) {
            if (!widget.m_5953_(mouseX, mouseY)) continue;
            this.requestSwap(widget.getAbilityNode());
            this.m_7379_();
            return true;
        }
        this.m_7379_();
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ModKeybinds.abilityWheelKey.getKey().m_84873_()) {
            Minecraft minecraft = Minecraft.m_91087_();
            double guiScaleFactor = minecraft.m_91268_().m_85449_();
            double mouseX = minecraft.f_91067_.m_91589_() / guiScaleFactor;
            double mouseY = minecraft.f_91067_.m_91594_() / guiScaleFactor;
            for (AbilitySelectionWidget widget : this.getAbilitiesAsWidgets()) {
                if (!widget.m_5953_(mouseX, mouseY)) continue;
                this.requestSwap(widget.getAbilityNode());
                break;
            }
            this.m_7379_();
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void requestSwap(AbilityNode<?, ?> abilityNode) {
        if (!abilityNode.getGroup().equals(ClientAbilityData.getSelectedAbility())) {
            ServerboundAbilitySelectMessage.send(abilityNode.getGroup().getParentName());
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        Minecraft minecraft = Minecraft.m_91087_();
        float midX = (float)minecraft.m_91268_().m_85445_() / 2.0f;
        float midY = (float)minecraft.m_91268_().m_85446_() / 2.0f;
        float radius = 60.0f;
        List<AbilitySelectionWidget> abilitiesAsWidgets = this.getAbilitiesAsWidgets();
        boolean focusRendered = false;
        for (AbilitySelectionWidget widget : abilitiesAsWidgets) {
            widget.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            if (focusRendered || !widget.m_5953_(mouseX, mouseY)) continue;
            int yOffset = 35;
            if (widget.getAbilityNode().getSpecialization() != null) {
                yOffset += 10;
            }
            String abilityName = widget.getAbilityNode().getName();
            int abilityNameWidth = minecraft.f_91062_.m_92895_(abilityName);
            minecraft.f_91062_.m_92750_(matrixStack, abilityName, midX - (float)abilityNameWidth / 2.0f, midY - (radius + (float)yOffset), 0xFFFFFF);
            if (widget.getAbilityNode().getSpecialization() != null) {
                String specName = widget.getAbilityNode().getSpecializationName();
                int specNameWidth = minecraft.f_91062_.m_92895_(specName);
                minecraft.f_91062_.m_92750_(matrixStack, specName, midX - (float)specNameWidth / 2.0f, midY - (radius + (float)yOffset - 10.0f), ChatFormatting.GOLD.m_126665_().intValue());
            }
            if (widget.getAbilityNode().getGroup().equals(ClientAbilityData.getSelectedAbility())) {
                String text = "Currently Focused Ability";
                int textWidth = minecraft.f_91062_.m_92895_(text);
                minecraft.f_91062_.m_92750_(matrixStack, text, midX - (float)textWidth / 2.0f, midY + (radius + 15.0f), 0xABEABE);
            }
            focusRendered = true;
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

