/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay.goal;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.client.gui.helper.MobHeadTextures;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.goal.BossBarOverlay;
import iskallia.vault.client.vault.goal.VaultScavengerData;
import iskallia.vault.config.LegacyScavengerHuntConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.vault.logic.objective.LegacyScavengerHuntObjective;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.RenderProperties;

public class ScavengerBarOverlay
extends BossBarOverlay {
    private final VaultScavengerData data;

    public ScavengerBarOverlay(VaultScavengerData data) {
        this.data = data;
    }

    @Override
    public boolean shouldDisplay() {
        List<LegacyScavengerHuntObjective.ItemSubmission> items = this.data.getRequiredItemSubmissions();
        return !items.isEmpty();
    }

    @Override
    public int drawOverlay(PoseStack renderStack, float pTicks) {
        List<LegacyScavengerHuntObjective.ItemSubmission> items = this.data.getRequiredItemSubmissions();
        Minecraft mc = Minecraft.m_91087_();
        int midX = mc.m_91268_().m_85445_() / 2;
        int gapWidth = 7;
        int itemBoxWidth = 32;
        int totalWidth = items.size() * itemBoxWidth + (items.size() - 1) * gapWidth;
        int shiftX = -totalWidth / 2 + itemBoxWidth / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        renderStack.m_85836_();
        int yOffset = 0;
        renderStack.m_85836_();
        renderStack.m_85837_((double)(midX + shiftX), (double)((float)itemBoxWidth * 0.75f), 0.0);
        for (LegacyScavengerHuntObjective.ItemSubmission itemRequirement : items) {
            int reqYOffset = ScavengerBarOverlay.renderItemRequirement(renderStack, itemRequirement, itemBoxWidth);
            if (reqYOffset > yOffset) {
                yOffset = reqYOffset;
            }
            renderStack.m_85837_((double)(itemBoxWidth + gapWidth), 0.0, 0.0);
        }
        renderStack.m_85849_();
        return yOffset;
    }

    private static int renderItemRequirement(PoseStack renderStack, LegacyScavengerHuntObjective.ItemSubmission itemRequirement, int itemBoxWidth) {
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        ItemStack requiredStack = new ItemStack((ItemLike)itemRequirement.getRequiredItem());
        LegacyScavengerHuntConfig.SourceType source = ModConfigs.LEGACY_SCAVENGER_HUNT.getRequirementSource(requiredStack);
        ResourceLocation iconPath = source == LegacyScavengerHuntConfig.SourceType.MOB ? MobHeadTextures.get(ModConfigs.LEGACY_SCAVENGER_HUNT.getRequirementMobType(requiredStack)).orElse(source.getIconPath()) : source.getIconPath();
        renderStack.m_85836_();
        renderStack.m_85837_(0.0, (double)((float)(-itemBoxWidth) / 2.0f), 0.0);
        ScavengerBarOverlay.renderItemStack(renderStack, requiredStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)iconPath);
        renderStack.m_85836_();
        renderStack.m_85837_(-16.0, -2.4, 0.0);
        renderStack.m_85841_(0.4f, 0.4f, 1.0f);
        ScreenDrawHelper.drawTexturedQuads(buf -> ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).dim(16.0f, 16.0f).draw());
        renderStack.m_85849_();
        renderStack.m_85837_(0.0, 10.0, 0.0);
        String requiredText = itemRequirement.getCurrentAmount() + "/" + itemRequirement.getRequiredAmount();
        MutableComponent cmp = new TextComponent(requiredText).m_130940_(ChatFormatting.GREEN);
        UIHelper.renderCenteredWrappedText(renderStack, (Component)cmp, 30, 0);
        renderStack.m_85837_(0.0, 10.0, 0.0);
        renderStack.m_85836_();
        renderStack.m_85841_(0.5f, 0.5f, 1.0f);
        Component name = requiredStack.m_41786_();
        MutableComponent display = name.m_6881_().m_130940_(source.getRequirementColor());
        int lines = UIHelper.renderCenteredWrappedText(renderStack, (Component)display, 60, 0);
        renderStack.m_85849_();
        renderStack.m_85849_();
        return 25 + lines * 5;
    }

    private static void renderItemStack(PoseStack renderStack, ItemStack item) {
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer ir = mc.m_91291_();
        Font fr = RenderProperties.get((ItemStack)item).getFont(item);
        if (fr == null) {
            fr = mc.f_91062_;
        }
        renderStack.m_85837_(-8.0, -8.0, 0.0);
        renderStack.m_85836_();
        renderStack.m_166854_(renderStack.m_85850_().m_85861_());
        ir.f_115093_ = 200.0f;
        ir.m_115203_(item, 0, 0);
        ir.m_115174_(fr, item, 0, 0, null);
        ir.f_115093_ = 0.0f;
        renderStack.m_85849_();
        renderStack.m_85837_(8.0, 8.0, 0.0);
    }
}

