/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay.goal;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.ClientVaultRaidData;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.vault.goal.VaultGoalData;
import iskallia.vault.client.vault.goal.VaultObeliskData;
import iskallia.vault.network.message.VaultOverlayMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ObeliskGoalOverlay {
    public static final ResourceLocation VAULT_HUD_RESOURCE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");

    @SubscribeEvent
    public static void onObeliskRender(RenderGameOverlayEvent.Post event) {
        VaultOverlayMessage.OverlayType type = ClientVaultRaidData.getOverlayType();
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || type != VaultOverlayMessage.OverlayType.VAULT) {
            return;
        }
        VaultGoalData data = VaultGoalData.CURRENT_DATA;
        if (data == null) {
            return;
        }
        if (data instanceof VaultObeliskData) {
            VaultObeliskData displayData = (VaultObeliskData)data;
            PoseStack renderStack = event.getMatrixStack();
            ObeliskGoalOverlay.renderObeliskMessage(renderStack, displayData);
            ObeliskGoalOverlay.renderObeliskIndicator(renderStack, displayData);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    private static void renderObeliskMessage(PoseStack matrixStack, VaultObeliskData data) {
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int bottom = mc.m_91268_().m_85446_();
        FormattedCharSequence bidiText = data.getMessage().m_7532_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(15.0, (double)(bottom - 34), 0.0);
        fr.m_92733_(bidiText, 0.0f, 0.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
    }

    private static void renderObeliskIndicator(PoseStack matrixStack, VaultObeliskData data) {
        int v;
        int u;
        int i;
        int maxObelisks = data.getMaxObelisks();
        int touchedObelisks = data.getCurrentObelisks();
        if (maxObelisks <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int untouchedObelisks = maxObelisks - touchedObelisks;
        int bottom = mc.m_91268_().m_85446_();
        float scale = 0.6f;
        int gap = 2;
        int margin = 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VAULT_HUD_RESOURCE);
        int iconWidth = 12;
        int iconHeight = 22;
        matrixStack.m_85836_();
        matrixStack.m_85837_(15.0, (double)(bottom - 34), 0.0);
        matrixStack.m_85837_(0.0, (double)(-margin), 0.0);
        matrixStack.m_85837_(0.0, (double)(-scale * (float)iconHeight), 0.0);
        matrixStack.m_85841_(scale, scale, scale);
        for (i = 0; i < touchedObelisks; ++i) {
            u = 77;
            v = 84;
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)u, (float)v, (int)iconWidth, (int)iconHeight, (int)256, (int)256);
            matrixStack.m_85837_((double)(scale * (float)gap + (float)iconWidth), 0.0, 0.0);
        }
        for (i = 0; i < untouchedObelisks; ++i) {
            u = 64;
            v = 84;
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)u, (float)v, (int)iconWidth, (int)iconHeight, (int)256, (int)256);
            matrixStack.m_85837_((double)(scale * (float)gap + (float)iconWidth), 0.0, 0.0);
        }
        matrixStack.m_85849_();
    }
}

