/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay.goal;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.client.ClientVaultRaidData;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.goal.BossBarOverlay;
import iskallia.vault.client.vault.goal.ArchitectGoalData;
import iskallia.vault.client.vault.goal.VaultGoalData;
import iskallia.vault.network.message.VaultOverlayMessage;
import iskallia.vault.world.vault.logic.objective.architect.DirectionChoice;
import iskallia.vault.world.vault.logic.objective.architect.VotingSession;
import iskallia.vault.world.vault.logic.objective.architect.modifier.VoteModifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArchitectGoalVoteOverlay
extends BossBarOverlay {
    private static final ResourceLocation ARCHITECT_HUD = new ResourceLocation("the_vault", "textures/gui/architect_event_bar.png");
    private final ArchitectGoalData data;

    public ArchitectGoalVoteOverlay(ArchitectGoalData data) {
        this.data = data;
    }

    @SubscribeEvent
    public static void onArchitectBuild(RenderGameOverlayEvent.Post event) {
        VaultOverlayMessage.OverlayType type = ClientVaultRaidData.getOverlayType();
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || type != VaultOverlayMessage.OverlayType.VAULT) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        VaultGoalData data = VaultGoalData.CURRENT_DATA;
        if (data instanceof ArchitectGoalData) {
            ArchitectGoalData displayData = (ArchitectGoalData)data;
            PoseStack renderStack = event.getMatrixStack();
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            Font fr = mc.f_91062_;
            int bottom = mc.m_91268_().m_85446_();
            float part = displayData.getCompletedPercent();
            MutableComponent txt = new TextComponent("Build the vault!").m_130940_(ChatFormatting.AQUA);
            fr.m_92733_(txt.m_7532_(), 8.0f, (float)(bottom - 60), -1, true, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            int lockTime = displayData.getTotalTicksUntilNextVote();
            String duration = UIHelper.formatTimeString(lockTime);
            txt = new TextComponent("Vote Lock Time");
            fr.m_92733_(txt.m_7532_(), 8.0f, (float)(bottom - 42), -1, true, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            txt = new TextComponent(duration).m_130940_(lockTime > 0 ? ChatFormatting.RED : ChatFormatting.GREEN);
            fr.m_92733_(txt.m_7532_(), 28.0f, (float)(bottom - 32), -1, true, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            buffer.m_109911_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ARCHITECT_HUD);
            ScreenDrawHelper.drawTexturedQuads(buf -> {
                ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(15.0f, bottom - 51).dim(54.0f, 7.0f).texVanilla(0.0f, 105.0f, 54.0f, 7.0f).draw();
                ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(16.0f, bottom - 50).dim(52.0f * part, 5.0f).texVanilla(0.0f, 113.0f, 52.0f * part, 5.0f).draw();
            });
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    @Override
    public boolean shouldDisplay() {
        return this.data.getTicksUntilNextVote() > 0 || this.data.getActiveSession() != null && !this.data.getActiveSession().getDirections().isEmpty();
    }

    @Override
    public int drawOverlay(PoseStack renderStack, float pTicks) {
        VotingSession activeSession = this.data.getActiveSession();
        if (!this.shouldDisplay()) {
            return 0;
        }
        Minecraft mc = Minecraft.m_91087_();
        int offsetY = 5;
        if (this.data.getTicksUntilNextVote() > 0) {
            offsetY = this.drawVotingTimer(this.data.getTicksUntilNextVote(), renderStack, offsetY);
        }
        if (activeSession != null && !activeSession.getDirections().isEmpty()) {
            offsetY = this.drawVotingSession(activeSession, renderStack, offsetY);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        return offsetY;
    }

    private int drawVotingTimer(int ticksUntilNextVote, PoseStack renderStack, int offsetY) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        int midX = mc.m_91268_().m_85445_() / 2;
        float scale = 1.25f;
        String tplText = "Voting locked: ";
        String text = tplText + UIHelper.formatTimeString(ticksUntilNextVote);
        float shift = (float)fr.m_92895_(tplText + "00:00") * 1.25f;
        MutableComponent textCmp = new TextComponent(text).m_130940_(ChatFormatting.RED);
        renderStack.m_85836_();
        renderStack.m_85837_((double)((float)midX - shift / 2.0f), (double)offsetY, 0.0);
        renderStack.m_85841_(scale, scale, 1.0f);
        fr.m_92841_((Component)textCmp, 0.0f, 0.0f, -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        renderStack.m_85849_();
        return offsetY + 13;
    }

    private int drawVotingSession(VotingSession activeSession, PoseStack renderStack, int offsetY) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        int midX = mc.m_91268_().m_85445_() / 2;
        int segmentWidth = 8;
        int barSegments = 22;
        int startEndWith = 4;
        int barWidth = segmentWidth * barSegments;
        int totalWidth = barWidth + startEndWith * 2;
        int offsetX = midX - totalWidth / 2;
        LinkedHashMap<DirectionChoice, Float> barParts = new LinkedHashMap<DirectionChoice, Float>();
        for (DirectionChoice choice : activeSession.getDirections()) {
            barParts.put(choice, Float.valueOf(activeSession.getChoicePercentage(choice)));
        }
        float shiftTitleX = (float)fr.m_92895_("Vote! 00:00") * 1.25f;
        String timeRemainingStr = UIHelper.formatTimeString(activeSession.getRemainingVoteTicks());
        MutableComponent title = new TextComponent("Vote! ").m_130946_(timeRemainingStr).m_130940_(ChatFormatting.AQUA);
        renderStack.m_85836_();
        renderStack.m_85837_((double)((float)midX - shiftTitleX / 2.0f), (double)offsetY, 0.0);
        renderStack.m_85841_(1.25f, 1.25f, 1.0f);
        fr.m_92841_((Component)title, 0.0f, 0.0f, -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        renderStack.m_85849_();
        offsetY = (int)((float)offsetY + 12.5f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ARCHITECT_HUD);
        this.drawBarContent(renderStack, offsetX + 1, offsetY + 1, barWidth, barParts);
        this.drawBarFrame(renderStack, offsetX, offsetY);
        offsetY += 12;
        offsetY += this.drawVoteChoices(renderStack, offsetX, offsetY, totalWidth, activeSession.getDirections());
        return offsetY;
    }

    private int drawVoteChoices(PoseStack renderStack, int offsetX, int offsetY, int totalWidth, List<DirectionChoice> choices) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        int maxHeight = 0;
        for (int i = 0; i < choices.size(); ++i) {
            DirectionChoice choice = choices.get(i);
            float offsetPart = ((float)i + 0.5f) / (float)choices.size();
            float barMid = (float)offsetX + offsetPart * (float)totalWidth;
            int yShift = 0;
            FormattedCharSequence bidiDir = choice.getDirectionDisplay("!").m_7532_();
            int dirLength = fr.m_92724_(bidiDir);
            fr.m_92733_(bidiDir, barMid - (float)dirLength / 2.0f, (float)(yShift + offsetY), -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
            float scaledShift = 0.0f;
            float modifierScale = 0.75f;
            renderStack.m_85836_();
            renderStack.m_85837_((double)barMid, (double)(offsetY + (yShift += 9)), 0.0);
            renderStack.m_85841_(modifierScale, modifierScale, 1.0f);
            for (VoteModifier modifier : choice.getModifiers()) {
                int changeSeconds = modifier.getVoteLockDurationChangeSeconds();
                if (changeSeconds != 0) {
                    ChatFormatting color = changeSeconds > 0 ? ChatFormatting.RED : ChatFormatting.GREEN;
                    Object changeDesc = changeSeconds > 0 ? "+" + changeSeconds : String.valueOf(changeSeconds);
                    MutableComponent line = new TextComponent((String)changeDesc + "s Vote Lock").m_130940_(color);
                    int voteLockLength = fr.m_92852_((FormattedText)line);
                    fr.m_92733_(line.m_7532_(), (float)(-voteLockLength) / 2.0f, 0.0f, -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
                    renderStack.m_85837_(0.0, 9.0, 0.0);
                    scaledShift += 9.0f;
                }
                FormattedCharSequence bidiDesc = modifier.getDescription().m_7532_();
                int descLength = fr.m_92724_(bidiDesc);
                fr.m_92733_(bidiDesc, (float)(-descLength) / 2.0f, 0.0f, -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
                renderStack.m_85837_(0.0, 9.0, 0.0);
                scaledShift += 9.0f;
            }
            renderStack.m_85849_();
            if ((yShift += Mth.m_14167_((float)(scaledShift * modifierScale))) <= maxHeight) continue;
            maxHeight = yShift;
        }
        buffer.m_109911_();
        return maxHeight;
    }

    private void drawBarContent(PoseStack renderStack, int offsetX, int offsetY, int barWidth, Map<DirectionChoice, Float> barParts) {
        ScreenDrawHelper.drawTexturedQuads(buf -> {
            float drawX = offsetX;
            DirectionChoice lastChoice = null;
            boolean drawStart = true;
            for (DirectionChoice choice : barParts.keySet()) {
                float part = ((Float)barParts.get(choice)).floatValue() * (float)barWidth;
                int vOffset = DirectionChoice.getVOffset(choice.getDirection());
                lastChoice = choice;
                if (drawStart) {
                    ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(offsetX, offsetY).dim(3.0f, 8.0f).texVanilla(0.0f, vOffset, 3.0f, 8.0f).draw();
                    drawX += 3.0f;
                    drawStart = false;
                }
                while (part > 0.0f) {
                    float length = Math.min(8.0f, part);
                    part -= length;
                    ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(drawX, offsetY).dim(length, 8.0f).texVanilla(100.0f, vOffset, length, 8.0f).draw();
                    drawX += length;
                }
            }
            int vOffset = DirectionChoice.getVOffset(lastChoice.getDirection());
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(drawX, offsetY).dim(3.0f, 8.0f).texVanilla(96.0f, vOffset, 3.0f, 8.0f).draw();
        });
    }

    private void drawBarFrame(PoseStack renderStack, int offsetX, int offsetY) {
        renderStack.m_85836_();
        ScreenDrawHelper.drawTexturedQuads(buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(offsetX, offsetY).dim(4.0f, 10.0f).texVanilla(0.0f, 11.0f, 4.0f, 10.0f).draw();
            int barOffsetX = offsetX + 4;
            for (int i = 0; i < 22; ++i) {
                ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(barOffsetX, offsetY).dim(8.0f, 10.0f).texVanilla(0.0f, 0.0f, 8.0f, 10.0f).draw();
                barOffsetX += 8;
            }
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(barOffsetX, offsetY).dim(4.0f, 10.0f).texVanilla(97.0f, 11.0f, 4.0f, 10.0f).draw();
        });
        renderStack.m_85849_();
    }
}

