/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay.goal;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.ClientVaultRaidData;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.vault.goal.AncientGoalData;
import iskallia.vault.client.vault.goal.VaultGoalData;
import iskallia.vault.network.message.VaultOverlayMessage;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public class AncientGoalOverlay
implements IIngameOverlay {
    public static final ResourceLocation VAULT_HUD_RESOURCE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");

    public void render(ForgeIngameGui gui, PoseStack renderStack, float partialTick, int width, int height) {
        VaultOverlayMessage.OverlayType type = ClientVaultRaidData.getOverlayType();
        if (type != VaultOverlayMessage.OverlayType.VAULT) {
            return;
        }
        VaultGoalData data = VaultGoalData.CURRENT_DATA;
        if (data == null) {
            return;
        }
        if (data instanceof AncientGoalData) {
            AncientGoalData displayData = (AncientGoalData)data;
            AncientGoalOverlay.renderAncientsMessage(renderStack, displayData);
            AncientGoalOverlay.renderAncientIndicator(renderStack, displayData);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    private static void renderAncientsMessage(PoseStack matrixStack, AncientGoalData data) {
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int bottom = mc.m_91268_().m_85446_();
        int offsetY = 54;
        ArrayList<FormattedCharSequence> msg = new ArrayList<FormattedCharSequence>();
        if (data.getTotalAncients() <= 0) {
            msg.add(new TextComponent("Hunt and escape").m_130940_(ChatFormatting.DARK_AQUA).m_130940_(ChatFormatting.BOLD).m_7532_());
            msg.add(new TextComponent("the Vault!").m_130940_(ChatFormatting.DARK_AQUA).m_130940_(ChatFormatting.BOLD).m_7532_());
            offsetY = 24;
        } else {
            String eternalPart = data.getTotalAncients() > 1 ? "eternals" : "eternal";
            msg.add(new TextComponent("Find your " + eternalPart).m_130940_(ChatFormatting.DARK_AQUA).m_130940_(ChatFormatting.BOLD).m_7532_());
            msg.add(new TextComponent("and escape the Vault!").m_130940_(ChatFormatting.DARK_AQUA).m_130940_(ChatFormatting.BOLD).m_7532_());
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(12.0, (double)(bottom - offsetY - msg.size() * 10), 0.0);
        for (int i = 0; i < msg.size(); ++i) {
            FormattedCharSequence txt = (FormattedCharSequence)msg.get(i);
            fr.m_92733_(txt, 0.0f, (float)(i * 10), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        }
        buffer.m_109911_();
        matrixStack.m_85849_();
    }

    private static void renderAncientIndicator(PoseStack matrixStack, AncientGoalData data) {
        int v;
        int u;
        int i;
        int totalAncients = data.getTotalAncients();
        int foundAncients = data.getFoundAncients();
        if (totalAncients <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int untouchedObelisks = totalAncients - foundAncients;
        int bottom = mc.m_91268_().m_85446_();
        float scale = 1.0f;
        int gap = 2;
        int margin = 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VAULT_HUD_RESOURCE);
        int iconWidth = 15;
        int iconHeight = 27;
        matrixStack.m_85836_();
        matrixStack.m_85837_(12.0, (double)(bottom - 24), 0.0);
        matrixStack.m_85837_(0.0, (double)(-margin), 0.0);
        matrixStack.m_85837_(0.0, (double)(-scale * (float)iconHeight), 0.0);
        matrixStack.m_85841_(scale, scale, scale);
        for (i = 0; i < foundAncients; ++i) {
            u = 81;
            v = 109;
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)u, (float)v, (int)iconWidth, (int)iconHeight, (int)256, (int)256);
            matrixStack.m_85837_((double)(scale * (float)gap + (float)iconWidth), 0.0, 0.0);
        }
        for (i = 0; i < untouchedObelisks; ++i) {
            u = 64;
            v = 109;
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)u, (float)v, (int)iconWidth, (int)iconHeight, (int)256, (int)256);
            matrixStack.m_85837_((double)(scale * (float)gap + (float)iconWidth), 0.0, 0.0);
        }
        matrixStack.m_85849_();
    }
}

