/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay.goal;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.goal.BossBarOverlay;
import iskallia.vault.client.vault.goal.ActiveRaidGoalData;
import iskallia.vault.client.vault.goal.VaultGoalData;
import iskallia.vault.world.vault.logic.objective.VaultModifierVotingSession;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ActiveRaidOverlay
extends BossBarOverlay {
    public static final ResourceLocation VAULT_HUD_RESOURCE = VaultMod.id("textures/gui/vault_hud.png");
    private final ActiveRaidGoalData data;

    public ActiveRaidOverlay(ActiveRaidGoalData data) {
        this.data = data;
    }

    @SubscribeEvent
    public static void onDrawPlayerlist(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            return;
        }
        VaultGoalData data = VaultGoalData.CURRENT_DATA;
        if (!(data instanceof ActiveRaidGoalData)) {
            return;
        }
        event.setCanceled(true);
    }

    @Override
    public boolean shouldDisplay() {
        return true;
    }

    @Override
    public int drawOverlay(PoseStack renderStack, float pTicks) {
        int offsetY = 5;
        offsetY = this.drawWaveDisplay(renderStack, pTicks, offsetY);
        offsetY = this.drawMobBar(renderStack, pTicks, offsetY);
        offsetY = this.drawModifierDisplay(renderStack, pTicks, offsetY);
        offsetY = this.drawVotingDisplay(renderStack, pTicks, offsetY);
        return offsetY;
    }

    private int drawWaveDisplay(PoseStack renderStack, float pTicks, int offsetY) {
        if (this.data.getTotalWaves() <= 0) {
            return offsetY;
        }
        String waveDisplay = String.format("%s / %s", this.data.getWave() + 1, this.data.getTotalWaves());
        Object fullDisplay = waveDisplay;
        if (this.data.getTickWaveDelay() > 0) {
            fullDisplay = (String)fullDisplay + " - " + UIHelper.formatTimeString(this.data.getTickWaveDelay());
        }
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        int width = fr.m_92895_(waveDisplay);
        float midX = (float)mc.m_91268_().m_85445_() / 2.0f;
        renderStack.m_85836_();
        renderStack.m_85837_((double)(midX - (float)width / 2.0f), (double)offsetY, 0.0);
        renderStack.m_85841_(1.25f, 1.25f, 1.0f);
        FontHelper.drawStringWithBorder(renderStack, (String)fullDisplay, 0.0f, 0.0f, 0xFFFFFF, 0);
        buffer.m_109911_();
        renderStack.m_85849_();
        return offsetY + 13;
    }

    private int drawMobBar(PoseStack renderStack, float pTicks, int offsetY) {
        if (this.data.getTotalWaves() <= 0) {
            return offsetY;
        }
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VAULT_HUD_RESOURCE);
        float killedPerc = (float)this.data.getAliveMobs() / (float)this.data.getTotalMobs();
        float midX = (float)mc.m_91268_().m_85445_() / 2.0f;
        int width = 182;
        int mobWidth = (int)((float)width * killedPerc);
        int totalWidth = width - mobWidth;
        ScreenDrawHelper.drawTexturedQuads(buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(midX - (float)width / 2.0f, offsetY).dim(mobWidth, 5.0f).texVanilla(0.0f, 168.0f, mobWidth, 5.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(midX - (float)width / 2.0f, offsetY).dim(mobWidth, 5.0f).texVanilla(0.0f, 178.0f, mobWidth, 5.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(midX - (float)width / 2.0f + (float)mobWidth, offsetY).dim(totalWidth, 5.0f).texVanilla(mobWidth, 163.0f, totalWidth, 5.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(midX - (float)width / 2.0f + (float)mobWidth, offsetY).dim(totalWidth, 5.0f).texVanilla(mobWidth, 173.0f, totalWidth, 5.0f).draw();
        });
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        return offsetY + 8;
    }

    private int drawModifierDisplay(PoseStack renderStack, float pTicks, int offsetY) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        int guiScale = mc.f_91066_.f_92072_;
        boolean drawAdditionalInfo = false;
        List<Component> positives = this.data.getPositives();
        List<Component> negatives = this.data.getNegatives();
        if (!mc.f_91066_.f_92099_.m_90857_()) {
            drawAdditionalInfo = positives.size() > 2 || negatives.size() > 2;
            positives = positives.subList(0, Math.min(positives.size(), 2));
            negatives = negatives.subList(0, Math.min(negatives.size(), 2));
        }
        float midX = (float)mc.m_91268_().m_85445_() / 2.0f;
        float scale = guiScale >= 4 || guiScale == 0 ? 0.7f : 1.0f;
        float height = 10.0f * scale;
        float maxHeight = (float)Math.max(positives.size(), negatives.size()) * height;
        if (this.data.getRaidsCompleted() > 0) {
            renderStack.m_85836_();
            renderStack.m_85837_((double)midX, (double)offsetY, 0.0);
            renderStack.m_85841_(scale, scale, 1.0f);
            Iterator<Component> raid = this.data.getRaidsCompleted() > 1 ? " Raids" : " Raid";
            String infoText = String.format("%d / %d %s Completed", this.data.getRaidsCompleted(), this.data.getTargetRaids(), raid);
            MutableComponent info = new TextComponent(infoText).m_130940_(ChatFormatting.GOLD);
            int width = fr.m_92852_((FormattedText)info);
            fr.m_92841_((Component)info, (float)(-width / 2), 0.0f, -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
            renderStack.m_85849_();
            offsetY = (int)((float)offsetY + (height + 1.0f));
        }
        renderStack.m_85836_();
        renderStack.m_85837_((double)(midX - 5.0f), (double)offsetY, 0.0);
        renderStack.m_85841_(scale, scale, 1.0f);
        for (Component positive : positives) {
            int width = fr.m_92852_((FormattedText)positive);
            fr.m_92841_(positive, (float)(-width), 0.0f, -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
            renderStack.m_85837_(0.0, 10.0, 0.0);
        }
        renderStack.m_85849_();
        renderStack.m_85836_();
        renderStack.m_85837_((double)(midX + 5.0f), (double)offsetY, 0.0);
        renderStack.m_85841_(scale, scale, 1.0f);
        for (Component negative : negatives) {
            fr.m_92841_(negative, 0.0f, 0.0f, -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
            renderStack.m_85837_(0.0, 10.0, 0.0);
        }
        renderStack.m_85849_();
        if (drawAdditionalInfo) {
            renderStack.m_85836_();
            renderStack.m_85837_((double)midX, (double)((float)offsetY + maxHeight), 0.0);
            renderStack.m_85841_(scale, scale, 1.0f);
            KeyMapping listSetting = mc.f_91066_.f_92099_;
            MutableComponent info = new TextComponent("Hold ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(listSetting.m_90863_());
            int width = fr.m_92852_((FormattedText)info);
            fr.m_92841_((Component)info, (float)(-width / 2), 0.0f, -1, false, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
            renderStack.m_85849_();
            maxHeight += height;
        }
        buffer.m_109911_();
        return Mth.m_14167_((float)((float)offsetY + maxHeight));
    }

    private int drawVotingDisplay(PoseStack renderStack, float pTicks, int offsetY) {
        if (this.data.getVotingSession() == null) {
            return offsetY;
        }
        VaultModifierVotingSession session = this.data.getVotingSession();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Minecraft mc = Minecraft.m_91087_();
        Font fr = mc.f_91062_;
        int guiScale = mc.f_91066_.f_92072_;
        float midX = (float)mc.m_91268_().m_85445_() / 2.0f;
        float scale = guiScale >= 4 || guiScale == 0 ? 1.0f : 1.2f;
        float height = 10.0f * scale;
        offsetY += 2;
        String voteStr = "Vote! " + UIHelper.formatTimeString(session.getVotingDuration()) + " ";
        TextComponent display = new TextComponent(voteStr);
        List<VaultModifier> modifiers = session.getModifiers();
        for (int i = 0; i < modifiers.size(); ++i) {
            VaultModifier choice = modifiers.get(i);
            if (i > 0) {
                display = display.m_7220_((Component)new TextComponent(" | ").m_130940_(ChatFormatting.GRAY));
            }
            display.m_7220_((Component)new TextComponent("!" + choice.getDisplayName().replaceAll("\\s", "").toLowerCase()).m_6270_(Style.f_131099_.m_131148_(choice.getDisplayTextColor())));
        }
        float width = fr.m_92852_((FormattedText)display);
        renderStack.m_85836_();
        renderStack.m_85837_((double)midX, (double)offsetY, 0.0);
        renderStack.m_85841_(scale, scale, 1.0f);
        fr.m_92841_((Component)display, -width / 2.0f, 0.0f, -1, true, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, true, 0, LightmapHelper.getPackedFullbrightCoords());
        renderStack.m_85849_();
        buffer.m_109911_();
        return offsetY + Mth.m_14167_((float)height);
    }
}

