/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientVaultRaidData;
import iskallia.vault.client.gui.overlay.SandEventOverlay;
import iskallia.vault.client.gui.overlay.goal.BossBarOverlay;
import iskallia.vault.client.vault.goal.VaultGoalData;
import iskallia.vault.network.message.VaultOverlayMessage;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class VaultGoalBossBarOverlay {
    @SubscribeEvent
    public static void onBossBarRender(RenderGameOverlayEvent.Pre event) {
        VaultOverlayMessage.OverlayType type = ClientVaultRaidData.getOverlayType();
        if (event.getType() != RenderGameOverlayEvent.ElementType.BOSSINFO) {
            return;
        }
        SandEventOverlay.overlayYOffset = 0;
        if (type != VaultOverlayMessage.OverlayType.VAULT) {
            return;
        }
        VaultGoalData data = VaultGoalData.CURRENT_DATA;
        if (data == null) {
            return;
        }
        BossBarOverlay overlay = data.getBossBarOverlay();
        if (overlay == null || !overlay.shouldDisplay()) {
            return;
        }
        PoseStack renderStack = event.getMatrixStack();
        int yOffset = overlay.drawOverlay(renderStack, event.getPartialTicks());
        SandEventOverlay.overlayYOffset = yOffset + 3;
        renderStack.m_85836_();
        renderStack.m_85837_(0.0, (double)SandEventOverlay.overlayYOffset, 0.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    @SubscribeEvent
    public static void onBossBarRenderPost(RenderGameOverlayEvent.Post event) {
        VaultOverlayMessage.OverlayType type = ClientVaultRaidData.getOverlayType();
        if (event.getType() != RenderGameOverlayEvent.ElementType.BOSSINFO || type != VaultOverlayMessage.OverlayType.VAULT) {
            return;
        }
        VaultGoalData data = VaultGoalData.CURRENT_DATA;
        if (data == null) {
            return;
        }
        BossBarOverlay overlay = data.getBossBarOverlay();
        if (overlay == null || !overlay.shouldDisplay()) {
            return;
        }
        event.getMatrixStack().m_85849_();
    }
}

