/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientSandEventData;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SandEventOverlay {
    public static int overlayYOffset = 0;
    private static final ResourceLocation HUD_TEXTURE = VaultMod.id("textures/gui/vault_hud.png");

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.BOSSINFO) {
            return;
        }
        if (!SandEventOverlay.shouldRender()) {
            return;
        }
        ClientSandEventData sandEventData = ClientSandEventData.getInstance();
        Minecraft mc = Minecraft.m_91087_();
        PoseStack renderStack = event.getMatrixStack();
        int midX = mc.m_91268_().m_85445_() / 2;
        int barWidth = 127;
        int barOffsetX = midX - barWidth / 2;
        int barOffsetY = 5;
        int barHeight = 9;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_TEXTURE);
        ScreenDrawHelper.drawTexturedQuads(buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(barOffsetX, barOffsetY).dim((float)barWidth * sandEventData.getFilledPercentage(), barHeight).texVanilla(62.0f, 67.0f, 99.0f * sandEventData.getFilledPercentage(), 7.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, renderStack).at(barOffsetX, barOffsetY).dim(barWidth, barHeight).texVanilla(62.0f, 60.0f, 99.0f, 7.0f).draw();
        });
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        renderStack.m_85836_();
        renderStack.m_85837_(0.0, 15.0, 0.0);
    }

    private static void drawContributors(PoseStack renderStack, int sandRight, int offsetY) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ClientSandEventData sandEventData = ClientSandEventData.getInstance();
        Font fr = Minecraft.m_91087_().f_91062_;
        float scale = 0.85f;
        renderStack.m_85836_();
        renderStack.m_85837_((double)(sandRight + 6), (double)offsetY, 500.0);
        renderStack.m_85841_(scale, scale, 1.0f);
        for (ClientSandEventData.ContributorDisplay display : sandEventData.getContributors()) {
            FormattedCharSequence bidiContributor = Language.m_128107_().m_5536_((FormattedText)display.getContributorDisplay());
            int alpha = (int)(255.0f * display.getRenderOpacity());
            int color = alpha << 24 | 0xFFFFFF;
            fr.m_92733_(bidiContributor, 0.0f, 0.0f, color, true, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            renderStack.m_85837_(0.0, 10.0, 0.0);
        }
        buffer.m_109911_();
        renderStack.m_85849_();
    }

    private static int drawSandDescriptions(PoseStack renderStack, int barOffsetLeft, int barOffsetRight, int barOffsetY) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ClientSandEventData sandEventData = ClientSandEventData.getInstance();
        Font fr = Minecraft.m_91087_().f_91062_;
        int current = sandEventData.getCollectedSand();
        int total = sandEventData.getTotalSand();
        float collectedPercent = (float)current / (float)total;
        int collectedColor = ChatFormatting.GREEN.m_126665_();
        if (collectedPercent < 0.1f) {
            collectedColor = ChatFormatting.DARK_RED.m_126665_();
        } else if (collectedPercent < 0.25f) {
            collectedColor = ChatFormatting.RED.m_126665_();
        } else if (collectedPercent < 0.5f) {
            collectedColor = 0xFFAA00;
        }
        MutableComponent sandCollected = new TextComponent("").m_7220_((Component)new TextComponent(String.valueOf(current)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)collectedColor)))).m_130946_(" / ").m_7220_((Component)new TextComponent(String.valueOf(total)).m_130940_(ChatFormatting.GOLD)).m_130946_(" Sand");
        FormattedCharSequence bidiSandCollected = Language.m_128107_().m_5536_((FormattedText)sandCollected);
        int sandCollectedLength = fr.m_92724_(bidiSandCollected);
        fr.m_92733_(bidiSandCollected, (float)(barOffsetRight + 5), (float)barOffsetY, -1, true, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        int percent = (int)(sandEventData.getFilledPercentage() * 100.0f);
        TextComponent sandBar = new TextComponent(percent + "%");
        FormattedCharSequence bidiSandBar = Language.m_128107_().m_5536_((FormattedText)sandBar);
        int sandPercentLength = fr.m_92724_(bidiSandBar);
        fr.m_92733_(bidiSandBar, (float)(barOffsetLeft - sandPercentLength - 5), (float)barOffsetY, -1, true, renderStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        return barOffsetRight + 5 + sandCollectedLength;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPostRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.BOSSINFO) {
            return;
        }
        if (!SandEventOverlay.shouldRender()) {
            return;
        }
        event.getMatrixStack().m_85849_();
    }

    @SubscribeEvent
    public static void onPostPotions(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!SandEventOverlay.shouldRender()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        PoseStack renderStack = event.getMatrixStack();
        int midX = mc.m_91268_().m_85445_() / 2;
        int barWidth = 127;
        int barOffsetX = midX - barWidth / 2;
        int barOffsetY = 5 + overlayYOffset;
        int barHeight = 9;
        int sandRight = SandEventOverlay.drawSandDescriptions(renderStack, barOffsetX, barOffsetX + barWidth, barOffsetY);
        SandEventOverlay.drawContributors(renderStack, sandRight, barOffsetY);
    }

    private static boolean shouldRender() {
        ClientSandEventData sandEventData = ClientSandEventData.getInstance();
        return sandEventData.isValid() && Minecraft.m_91087_().f_91074_ != null;
    }
}

