/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ScreenDrawHelper {
    public static void drawTexturedQuads(Consumer<BufferBuilder> fn) {
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, fn);
    }

    public static void draw(VertexFormat.Mode drawMode, VertexFormat format, Consumer<BufferBuilder> fn) {
        ScreenDrawHelper.draw(drawMode, format, (BufferBuilder bufferBuilder) -> {
            fn.accept((BufferBuilder)bufferBuilder);
            return null;
        });
    }

    public static <R> R draw(VertexFormat.Mode drawMode, VertexFormat format, Function<BufferBuilder, R> fn) {
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(drawMode, format);
        R result = fn.apply(buf);
        buf.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buf);
        return result;
    }

    public static QuadBuilder rect(VertexConsumer buf, PoseStack renderStack) {
        return new QuadBuilder(buf, renderStack);
    }

    public static QuadBuilder rect(VertexConsumer buf, PoseStack renderStack, float width, float height) {
        return ScreenDrawHelper.rect(buf, renderStack, 0.0f, 0.0f, 0.0f, width, height);
    }

    public static QuadBuilder rect(VertexConsumer buf, PoseStack renderStack, float offsetX, float offsetY, float offsetZ, float width, float height) {
        return new QuadBuilder(buf, renderStack, offsetX, offsetY, offsetZ, width, height);
    }

    public static class QuadBuilder {
        private final VertexConsumer buf;
        private final PoseStack renderStack;
        private float offsetX;
        private float offsetY;
        private float offsetZ;
        private float width;
        private float height;
        private float u = 0.0f;
        private float v = 0.0f;
        private float uWidth = 1.0f;
        private float vWidth = 1.0f;
        private Color color = Color.WHITE;

        private QuadBuilder(VertexConsumer buf, PoseStack renderStack) {
            this.buf = buf;
            this.renderStack = renderStack;
        }

        private QuadBuilder(VertexConsumer buf, PoseStack renderStack, float offsetX, float offsetY, float offsetZ, float width, float height) {
            this.buf = buf;
            this.renderStack = renderStack;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.width = width;
            this.height = height;
        }

        public QuadBuilder at(float offsetX, float offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            return this;
        }

        public QuadBuilder zLevel(float offsetZ) {
            this.offsetZ = offsetZ;
            return this;
        }

        public QuadBuilder dim(float width, float height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public QuadBuilder tex(TextureAtlasSprite tas) {
            return this.tex(tas.m_118409_(), tas.m_118411_(), tas.m_118410_() - tas.m_118409_(), tas.m_118412_() - tas.m_118411_());
        }

        public QuadBuilder texVanilla(float pxU, float pxV, float pxWidth, float pxHeight) {
            return this.texTexturePart(pxU, pxV, pxWidth, pxHeight, 256.0f, 256.0f);
        }

        public QuadBuilder texTexturePart(float pxU, float pxV, float pxWidth, float pxHeight, float texPxWidth, float texPxHeight) {
            return this.tex(pxU / texPxWidth, pxV / texPxHeight, pxWidth / texPxWidth, pxHeight / texPxHeight);
        }

        public QuadBuilder tex(float u, float v, float uWidth, float vWidth) {
            this.u = u;
            this.v = v;
            this.uWidth = uWidth;
            this.vWidth = vWidth;
            return this;
        }

        public QuadBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public QuadBuilder color(int color) {
            return this.color(new Color(color, true));
        }

        public QuadBuilder color(int r, int g, int b, int a) {
            return this.color(new Color(r, g, b, a));
        }

        public QuadBuilder color(float r, float g, float b, float a) {
            return this.color(new Color(r, g, b, a));
        }

        public QuadBuilder drawColored() {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            int r = this.color.getRed();
            int g = this.color.getGreen();
            int b = this.color.getBlue();
            int a = this.color.getAlpha();
            Matrix4f offset = this.renderStack.m_85850_().m_85861_();
            this.buf.m_85982_(offset, this.offsetX, this.offsetY + this.height, this.offsetZ).m_6122_(r, g, b, a).m_5752_();
            this.buf.m_85982_(offset, this.offsetX + this.width, this.offsetY + this.height, this.offsetZ).m_6122_(r, g, b, a).m_5752_();
            this.buf.m_85982_(offset, this.offsetX + this.width, this.offsetY, this.offsetZ).m_6122_(r, g, b, a).m_5752_();
            this.buf.m_85982_(offset, this.offsetX, this.offsetY, this.offsetZ).m_6122_(r, g, b, a).m_5752_();
            return this;
        }

        public QuadBuilder draw() {
            RenderSystem.m_157427_(GameRenderer::m_172814_);
            int r = this.color.getRed();
            int g = this.color.getGreen();
            int b = this.color.getBlue();
            int a = this.color.getAlpha();
            Matrix4f offset = this.renderStack.m_85850_().m_85861_();
            this.buf.m_85982_(offset, this.offsetX, this.offsetY + this.height, this.offsetZ).m_6122_(r, g, b, a).m_7421_(this.u, this.v + this.vWidth).m_5752_();
            this.buf.m_85982_(offset, this.offsetX + this.width, this.offsetY + this.height, this.offsetZ).m_6122_(r, g, b, a).m_7421_(this.u + this.uWidth, this.v + this.vWidth).m_5752_();
            this.buf.m_85982_(offset, this.offsetX + this.width, this.offsetY, this.offsetZ).m_6122_(r, g, b, a).m_7421_(this.u + this.uWidth, this.v).m_5752_();
            this.buf.m_85982_(offset, this.offsetX, this.offsetY, this.offsetZ).m_6122_(r, g, b, a).m_7421_(this.u, this.v).m_5752_();
            return this;
        }
    }
}

