/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element.spi;

import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.element.spi.ISpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ITooltipElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ElementStore {
    private final List<IGuiEventElement> guiEventListenerList = new ArrayList<IGuiEventElement>(0);
    private final List<IRenderedElement> renderedElementList = new ArrayList<IRenderedElement>(0);
    private final List<ISpatialElement> spatialElementList = new ArrayList<ISpatialElement>(0);
    private final List<ILayoutElement<?>> layoutElementList = new ArrayList(0);
    private final List<ITooltipElement> tooltipElementList = new ArrayList<ITooltipElement>(0);
    private final List<IGuiEventElement> unmodifiableGuiEventElementList = Collections.unmodifiableList(this.guiEventListenerList);
    private final List<IRenderedElement> unmodifiableRenderedElementList = Collections.unmodifiableList(this.renderedElementList);
    private final List<ISpatialElement> unmodifiableSpatialElementList = Collections.unmodifiableList(this.spatialElementList);
    private final List<ILayoutElement<?>> unmodifiableLayoutElementList = Collections.unmodifiableList(this.layoutElementList);
    private final List<ITooltipElement> unmodifiableTooltipElementList = Collections.unmodifiableList(this.tooltipElementList);

    public <E extends IElement> E addElement(E element) {
        if (element instanceof IGuiEventElement) {
            IGuiEventElement guiEventListener = (IGuiEventElement)element;
            this.guiEventListenerList.add(guiEventListener);
        }
        if (element instanceof IRenderedElement) {
            IRenderedElement renderedElement = (IRenderedElement)element;
            this.renderedElementList.add(renderedElement);
        }
        if (element instanceof ISpatialElement) {
            ISpatialElement spatialElement = (ISpatialElement)element;
            this.spatialElementList.add(spatialElement);
        }
        if (element instanceof ILayoutElement) {
            ILayoutElement layoutElement = (ILayoutElement)element;
            this.layoutElementList.add(layoutElement);
        }
        if (element instanceof ITooltipElement) {
            ITooltipElement tooltipElement = (ITooltipElement)element;
            this.tooltipElementList.add(tooltipElement);
        }
        return element;
    }

    public void removeElement(IElement element) {
        if (element instanceof IGuiEventElement) {
            IGuiEventElement guiEventListener = (IGuiEventElement)element;
            this.guiEventListenerList.remove(guiEventListener);
        }
        if (element instanceof IRenderedElement) {
            IRenderedElement renderedElement = (IRenderedElement)element;
            this.renderedElementList.remove(renderedElement);
        }
        if (element instanceof ISpatialElement) {
            ISpatialElement spatialElement = (ISpatialElement)element;
            this.spatialElementList.remove(spatialElement);
        }
        if (element instanceof ILayoutElement) {
            ILayoutElement layoutElement = (ILayoutElement)element;
            this.layoutElementList.remove(layoutElement);
        }
        if (element instanceof ITooltipElement) {
            ITooltipElement tooltipElement = (ITooltipElement)element;
            this.tooltipElementList.remove(tooltipElement);
        }
    }

    public void removeAllElements() {
        this.guiEventListenerList.clear();
        this.renderedElementList.clear();
        this.spatialElementList.clear();
        this.layoutElementList.clear();
        this.tooltipElementList.clear();
    }

    public List<IGuiEventElement> getGuiEventElementList() {
        return this.unmodifiableGuiEventElementList;
    }

    public List<IRenderedElement> getRenderedElementList() {
        return this.unmodifiableRenderedElementList;
    }

    public List<ISpatialElement> getSpatialElementList() {
        return this.unmodifiableSpatialElementList;
    }

    public List<ILayoutElement<?>> getLayoutElementList() {
        return this.unmodifiableLayoutElementList;
    }

    public List<ITooltipElement> getTooltipElementList() {
        return this.unmodifiableTooltipElementList;
    }
}

