/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.container.slot.spi.IGhostSlot;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SlotsElement<E extends SlotsElement<E>>
extends AbstractSpatialElement<E>
implements IRenderedElement {
    protected final List<Slot> slots;
    protected final TextureAtlasRegion background;
    protected boolean visible;

    public SlotsElement(MenuAccess<?> containerScreen) {
        this(Spatials.zero(), (List<Slot>)containerScreen.m_6262_().f_38839_);
    }

    public SlotsElement(IPosition position, List<Slot> slots) {
        this(position, slots, ScreenTextures.INSET_ITEM_SLOT_BACKGROUND);
    }

    public SlotsElement(IPosition position, List<Slot> slots, TextureAtlasRegion background) {
        super(Spatials.positionXYZ(position).size(SlotsElement.calculateElementWidth(slots), SlotsElement.calculateElementHeight(slots)));
        this.slots = slots;
        this.background = background;
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        for (Slot slot : this.slots) {
            IGhostSlot ghostSlot;
            ItemStack ghostItemStack;
            renderer.render(this.background, poseStack, slot.f_40220_ + this.worldSpatial.x() - 1, slot.f_40221_ + this.worldSpatial.y() - 1, this.worldSpatial.z());
            if (!(slot instanceof IGhostSlot) || (ghostItemStack = (ghostSlot = (IGhostSlot)slot).getGhostItemStack()) == null) continue;
            this.renderItemStack(ghostItemStack, slot.f_40220_ + this.worldSpatial.x(), slot.f_40221_ + this.worldSpatial.y(), this.worldSpatial.z() + 1);
        }
    }

    private void renderItemStack(ItemStack itemStack, float x, float y, float z) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        PoseStack poseStack2 = new PoseStack();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, (double)z);
        posestack.m_85837_(8.0, 8.0, 8.0);
        posestack.m_85841_(16.0f, -16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack2, (MultiBufferSource)bufferSource, LightmapHelper.getPackedLightCoords(5), OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private static int calculateElementWidth(List<Slot> slots) {
        int result = 0;
        for (Slot slot : slots) {
            if (slot.f_40220_ + 18 <= result) continue;
            result = slot.f_40220_ + 18;
        }
        return result;
    }

    private static int calculateElementHeight(List<Slot> slots) {
        int result = 0;
        for (Slot slot : slots) {
            if (slot.f_40221_ + 18 <= result) continue;
            result = slot.f_40221_ + 18;
        }
        return result;
    }
}

