/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class EntityModelElement<E extends EntityModelElement<E>>
extends ElasticContainerElement<E> {
    protected final Supplier<LivingEntity> livingEntitySupplier;
    protected final IPosition entityOffset;
    protected final float entityScale;

    public EntityModelElement(IPosition position, ISize size, Supplier<LivingEntity> livingEntitySupplier) {
        this(position, size, livingEntitySupplier, IPosition.ZERO, 1.0f);
    }

    public EntityModelElement(IPosition position, ISize size, Supplier<LivingEntity> livingEntitySupplier, IPosition entityOffset, float entityScale) {
        super(Spatials.positionXYZ(position));
        this.livingEntitySupplier = livingEntitySupplier;
        this.entityOffset = entityOffset;
        this.entityScale = entityScale;
        this.addElement(new NineSliceElement(Spatials.size(size), ScreenTextures.INSET_BLACK_BACKGROUND));
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        LivingEntity livingEntity = this.livingEntitySupplier.get();
        if (livingEntity != null) {
            ISpatial worldSpatial = this.getWorldSpatial();
            int playerRenderX = worldSpatial.x() + worldSpatial.width() / 2 + this.entityOffset.x();
            int playerRenderY = worldSpatial.y() + (worldSpatial.height() - 16) + this.entityOffset.y();
            poseStack.m_85836_();
            poseStack.m_85837_((double)playerRenderX, (double)playerRenderY, (double)this.entityOffset.z());
            poseStack.m_85841_(this.entityScale, this.entityScale, this.entityScale);
            this.renderEntity(livingEntity, poseStack, playerRenderX - mouseX, playerRenderY - mouseY - 50);
            poseStack.m_85849_();
        }
    }

    public void renderEntity(LivingEntity entity, PoseStack renderStack, int containerMouseX, int containerMouseY) {
        float xYaw = (float)Math.atan((float)containerMouseX / 40.0f);
        float yPitch = (float)Math.atan((float)containerMouseY / 40.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_(0.0, 0.0, 350.0);
        modelViewStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        renderStack.m_85836_();
        renderStack.m_85841_(30.0f, 30.0f, 30.0f);
        Quaternion rotationZ = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion rotationX = Vector3f.f_122223_.m_122240_(yPitch * 20.0f);
        rotationZ.m_80148_(rotationX);
        renderStack.m_85845_(rotationZ);
        float yBodyRot = entity.f_20883_;
        float yRot = entity.m_146908_();
        float xRot = entity.m_146909_();
        float yHeadRotO = entity.f_20886_;
        float yHeadRot = entity.f_20885_;
        entity.f_20883_ = 180.0f + xYaw * 20.0f;
        entity.m_146922_(180.0f + xYaw * 40.0f);
        entity.m_146926_(-yPitch * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        RenderSystem.m_157450_((Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(0.2f, -1.0f, -1.0f), Vector3f::m_122278_)), (Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(0.0f, -0.5f, 1.0f), Vector3f::m_122278_)));
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        rotationX.m_80157_();
        entityRenderDispatcher.m_114412_(rotationX);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, renderStack, (MultiBufferSource)multiBufferSource, 0xF000F0));
        multiBufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        entity.f_20883_ = yBodyRot;
        entity.m_146922_(yRot);
        entity.m_146926_(xRot);
        entity.f_20886_ = yHeadRotO;
        entity.f_20885_ = yHeadRot;
        renderStack.m_85849_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
        Lighting.m_84931_();
    }
}

