/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ButtonElement<E extends ButtonElement<E>>
extends AbstractSpatialElement<E>
implements IRenderedElement,
IGuiEventElement {
    private final ButtonTextures textures;
    private final Runnable onClick;
    protected boolean visible;
    protected Supplier<Boolean> disabled;
    private boolean clickHeld = false;

    public ButtonElement(IPosition position, ButtonTextures textures, Runnable onClick) {
        super(Spatials.positionXYZ(position).size(textures.button().size()));
        this.textures = textures;
        this.onClick = onClick;
        this.setVisible(true);
        this.setDisabled(false);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public ButtonElement<E> setDisabled(boolean disabled) {
        this.setDisabled(() -> disabled);
        return this;
    }

    public ButtonElement<E> setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        this.clickHeld = true;
        return true;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        boolean dragged = IGuiEventElement.super.m_7979_(mouseX, mouseY, buttonIndex, dragX, dragY);
        if (!this.containsMouse(mouseX, mouseY)) {
            this.clickHeld = false;
        }
        return dragged;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int buttonIndex) {
        if (!this.isDisabled() && this.clickHeld) {
            this.onClick.run();
        }
        return true;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonIndex) {
        boolean release = IGuiEventElement.super.m_6348_(mouseX, mouseY, buttonIndex);
        this.clickHeld = false;
        return release;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        TextureAtlasRegion texture = this.textures.selectTexture(this.isDisabled(), this.containsMouse(mouseX, mouseY), this.clickHeld);
        renderer.render(texture, poseStack, (IPosition)this.worldSpatial);
    }

    public record ButtonTextures(TextureAtlasRegion button, TextureAtlasRegion buttonHover, TextureAtlasRegion buttonHeld, TextureAtlasRegion buttonDisabled) {
        private TextureAtlasRegion selectTexture(boolean disabled, boolean hover, boolean clicked) {
            if (disabled) {
                return this.buttonDisabled();
            }
            if (clicked) {
                return this.buttonHeld();
            }
            if (hover) {
                return this.buttonHover();
            }
            return this.button();
        }
    }
}

