/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.Renderable;
import iskallia.vault.client.gui.helper.UIHelper;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScrollableContainer
extends GuiComponent {
    public static final ResourceLocation UI_RESOURCE = new ResourceLocation("the_vault", "textures/gui/ability_tree.png");
    public static final int SCROLL_WIDTH = 8;
    protected Rectangle bounds;
    protected Renderable renderer;
    protected int innerHeight;
    protected int yOffset;
    protected boolean scrolling;
    protected double scrollingStartY;
    protected int scrollingOffsetY;

    public ScrollableContainer(Renderable renderer) {
        this.renderer = renderer;
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public float scrollPercentage() {
        Rectangle scrollBounds = this.getScrollBounds();
        return (float)this.yOffset / (float)(this.innerHeight - scrollBounds.height);
    }

    public void setInnerHeight(int innerHeight) {
        this.innerHeight = innerHeight;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public Rectangle getRenderableBounds() {
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width - 8 + 2, this.bounds.height);
    }

    public Rectangle getScrollBounds() {
        return new Rectangle(this.bounds.x + this.bounds.width - 8, this.bounds.y, 8, this.bounds.height);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.scrolling) {
            double deltaY = mouseY - this.scrollingStartY;
            Rectangle renderableBounds = this.getRenderableBounds();
            Rectangle scrollBounds = this.getScrollBounds();
            double deltaOffset = deltaY * (double)this.innerHeight / scrollBounds.getHeight();
            this.yOffset = Mth.m_14045_((int)(this.scrollingOffsetY + (int)(deltaOffset * (double)this.innerHeight / (double)scrollBounds.height)), (int)0, (int)(this.innerHeight - renderableBounds.height + 2));
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        Rectangle renderableBounds = this.getRenderableBounds();
        Rectangle scrollBounds = this.getScrollBounds();
        float viewportRatio = (float)renderableBounds.getHeight() / (float)this.innerHeight;
        if (viewportRatio < 1.0f && scrollBounds.contains((int)mouseX, (int)mouseY)) {
            this.scrolling = true;
            this.scrollingStartY = mouseY;
            this.scrollingOffsetY = this.yOffset;
        }
    }

    public void mouseReleased(double mouseX, double mouseY, int button) {
        this.scrolling = false;
    }

    public void mouseScrolled(double mouseX, double mouseY, double delta) {
        Rectangle renderableBounds = this.getRenderableBounds();
        float viewportRatio = (float)renderableBounds.getHeight() / (float)this.innerHeight;
        if (viewportRatio < 1.0f) {
            this.yOffset = Mth.m_14045_((int)(this.yOffset + (int)(-delta * 5.0)), (int)0, (int)(this.innerHeight - renderableBounds.height + 2));
        }
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        Rectangle renderBounds = this.getRenderableBounds();
        Rectangle scrollBounds = this.getScrollBounds();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        UIHelper.renderContainerBorder(this, matrixStack, renderBounds, 14, 44, 2, 2, 2, 2, -7631989);
        UIHelper.renderOverflowHidden(matrixStack, ms -> ScrollableContainer.m_93172_((PoseStack)ms, (int)(renderBounds.x + 1), (int)(renderBounds.y + 1), (int)(renderBounds.x + renderBounds.width - 1), (int)(renderBounds.y + renderBounds.height - 1), (int)-7631989), ms -> {
            ms.m_85836_();
            ms.m_85837_((double)(renderBounds.x + 1), (double)(renderBounds.y - this.yOffset + 1), 0.0);
            this.renderer.render(matrixStack, mouseX, mouseY, partialTicks);
            ms.m_85849_();
        });
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(scrollBounds.x + 2), (double)scrollBounds.y, 0.0);
        matrixStack.m_85841_(1.0f, (float)scrollBounds.height, 1.0f);
        this.m_93228_(matrixStack, 0, 0, 1, 146, 6, 1);
        matrixStack.m_85849_();
        this.m_93228_(matrixStack, scrollBounds.x + 2, scrollBounds.y, 1, 145, 6, 1);
        this.m_93228_(matrixStack, scrollBounds.x + 2, scrollBounds.y + scrollBounds.height - 1, 1, 251, 6, 1);
        float scrollPercentage = this.scrollPercentage();
        float viewportRatio = (float)renderBounds.getHeight() / (float)this.innerHeight;
        int scrollHeight = (int)(renderBounds.getHeight() * (double)viewportRatio);
        if (viewportRatio <= 1.0f) {
            int scrollU = this.scrolling ? 28 : (scrollBounds.contains(mouseX, mouseY) ? 18 : 8);
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, (scrollBounds.getHeight() - (double)scrollHeight) * (double)scrollPercentage, 0.0);
            this.m_93228_(matrixStack, scrollBounds.x + 1, scrollBounds.y, scrollU, 104, 8, scrollHeight);
            this.m_93228_(matrixStack, scrollBounds.x + 1, scrollBounds.y - 2, scrollU, 101, 8, 2);
            this.m_93228_(matrixStack, scrollBounds.x + 1, scrollBounds.y + scrollHeight, scrollU, 253, 8, 2);
            matrixStack.m_85849_();
        }
    }
}

