/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.atlas;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.IMultiBuffer;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public record TextureAtlasRegion(Supplier<ITextureAtlas> atlas, ResourceLocation resourceLocation) implements ISize
{
    public static TextureAtlasRegion of(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation) {
        return new TextureAtlasRegion(atlasSupplier, resourceLocation);
    }

    public void blit(PoseStack poseStack, IPosition position) {
        this.blit(poseStack, position.x(), position.y(), position.z());
    }

    public void blit(PoseStack poseStack, IPosition position, ISize size) {
        this.blit(poseStack, position, size.width(), size.height());
    }

    public void blit(PoseStack poseStack, IPosition position, int width, int height) {
        this.blit(poseStack, position.x(), position.y(), position.z(), width, height);
    }

    public void blit(PoseStack poseStack, int x, int y) {
        this.blit(poseStack, x, y, 0);
    }

    public void blit(PoseStack poseStack, int x, int y, int z) {
        TextureAtlasSprite sprite = this.atlas.get().getSprite(this.resourceLocation);
        this.blit(poseStack, x, y, z, sprite.m_118405_(), sprite.m_118408_(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public void blit(PoseStack poseStack, int x, int y, int z, int width, int height) {
        TextureAtlasSprite sprite = this.atlas.get().getSprite(this.resourceLocation);
        this.blit(poseStack, x, y, z, width, height, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public void blit(PoseStack poseStack, int x, int y, int z, int width, int height, float u0, float u1, float v0, float v1) {
        TextureAtlasSprite sprite = this.getSprite();
        u0 = Mth.m_14036_((float)u0, (float)sprite.m_118409_(), (float)sprite.m_118410_());
        u1 = Mth.m_14036_((float)u1, (float)sprite.m_118409_(), (float)sprite.m_118410_());
        v0 = Mth.m_14036_((float)v0, (float)sprite.m_118411_(), (float)sprite.m_118412_());
        v1 = Mth.m_14036_((float)v1, (float)sprite.m_118411_(), (float)sprite.m_118412_());
        this.bindTexture();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        this.buffer((VertexConsumer)bufferbuilder, poseStack, x, y, z, width, height, u0, u1, v0, v1);
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public void buffer(IMultiBuffer buffer, PoseStack poseStack, IPosition position) {
        this.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, position.x(), position.y(), position.z());
    }

    public void buffer(IMultiBuffer buffer, PoseStack poseStack, IPosition position, ISize size) {
        this.buffer(buffer, poseStack, position, size.width(), size.height());
    }

    public void buffer(IMultiBuffer buffer, PoseStack poseStack, IPosition position, int width, int height) {
        this.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, position.x(), position.y(), position.z(), width, height);
    }

    public void buffer(IMultiBuffer buffer, PoseStack poseStack, int x, int y) {
        this.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, x, y);
    }

    public void buffer(IMultiBuffer buffer, PoseStack poseStack, int x, int y, int z) {
        this.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, x, y, z);
    }

    public void buffer(IMultiBuffer buffer, PoseStack poseStack, int x, int y, int z, int width, int height) {
        this.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, x, y, z, width, height);
    }

    public void buffer(IMultiBuffer buffer, PoseStack poseStack, int x, int y, int z, int width, int height, float u0, float u1, float v0, float v1) {
        this.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, x, y, z, width, height, u0, u1, v0, v1);
    }

    public void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int x, int y) {
        TextureAtlasSprite sprite = this.getSprite();
        this.buffer(vertexConsumer, poseStack, x, y, 0, sprite.m_118405_(), sprite.m_118408_(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int x, int y, int z) {
        TextureAtlasSprite sprite = this.getSprite();
        this.buffer(vertexConsumer, poseStack, x, y, z, sprite.m_118405_(), sprite.m_118408_(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int x, int y, int z, int width, int height) {
        TextureAtlasSprite sprite = this.getSprite();
        this.buffer(vertexConsumer, poseStack, x, y, z, width, height, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int x, int y, int z, int width, int height, float u0, float u1, float v0, float v1) {
        TextureAtlasSprite sprite = this.getSprite();
        u0 = Mth.m_14036_((float)u0, (float)sprite.m_118409_(), (float)sprite.m_118410_());
        u1 = Mth.m_14036_((float)u1, (float)sprite.m_118409_(), (float)sprite.m_118410_());
        v0 = Mth.m_14036_((float)v0, (float)sprite.m_118411_(), (float)sprite.m_118412_());
        v1 = Mth.m_14036_((float)v1, (float)sprite.m_118411_(), (float)sprite.m_118412_());
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        vertexConsumer.m_85982_(matrix, (float)x, (float)(y + height), (float)z).m_7421_(u0, v1).m_5752_();
        vertexConsumer.m_85982_(matrix, (float)(x + width), (float)(y + height), (float)z).m_7421_(u1, v1).m_5752_();
        vertexConsumer.m_85982_(matrix, (float)(x + width), (float)y, (float)z).m_7421_(u1, v0).m_5752_();
        vertexConsumer.m_85982_(matrix, (float)x, (float)y, (float)z).m_7421_(u0, v0).m_5752_();
    }

    public TextureAtlasSprite getSprite() {
        return this.atlas.get().getSprite(this.resourceLocation);
    }

    public float getU0(float percentage) {
        TextureAtlasSprite sprite = this.getSprite();
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        return Mth.m_14036_((float)(u1 - (u1 - u0) * percentage), (float)u0, (float)u1);
    }

    public float getU1(float percentage) {
        TextureAtlasSprite sprite = this.getSprite();
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        return Mth.m_14036_((float)(u0 + (u1 - u0) * percentage), (float)u0, (float)u1);
    }

    public float getV0(float percentage) {
        TextureAtlasSprite sprite = this.getSprite();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        return Mth.m_14036_((float)(v1 - (v1 - v0) * percentage), (float)v0, (float)v1);
    }

    public float getV1(float percentage) {
        TextureAtlasSprite sprite = this.getSprite();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        return Mth.m_14036_((float)(v0 + (v1 - v0) * percentage), (float)v0, (float)v1);
    }

    public void bindTexture() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.atlas.get().getAtlasResourceLocation());
    }

    @Override
    public String toString() {
        return "TextureAtlasRegion{" + this.atlas.get().getAtlasResourceLocation() + ", " + this.resourceLocation + "}";
    }

    @Override
    public int width() {
        return this.getSprite().m_118405_();
    }

    @Override
    public int height() {
        return this.getSprite().m_118408_();
    }

    public ISize size() {
        return this;
    }
}

