/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client;

import iskallia.vault.VaultMod;
import iskallia.vault.client.vault.VaultMusicHandler;
import iskallia.vault.client.vault.goal.VaultGoalData;
import iskallia.vault.network.message.BossMusicMessage;
import iskallia.vault.network.message.VaultModifierMessage;
import iskallia.vault.network.message.VaultOverlayMessage;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.vault.modifier.VaultModifiers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientVaultRaidData {
    private static int remainingTicks = 0;
    private static boolean canGetRecordTime = false;
    private static VaultOverlayMessage.OverlayType type = VaultOverlayMessage.OverlayType.NONE;
    private static boolean showTimer = true;
    private static VaultModifiers modifiers = new VaultModifiers();
    private static boolean inBossFight = false;

    public static int getRemainingTicks() {
        return remainingTicks;
    }

    public static boolean canGetRecordTime() {
        return canGetRecordTime;
    }

    public static VaultOverlayMessage.OverlayType getOverlayType() {
        return type;
    }

    public static boolean showTimer() {
        return showTimer;
    }

    public static VaultModifiers getModifiers() {
        return modifiers;
    }

    public static boolean isInBossFight() {
        return inBossFight;
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        inBossFight = false;
        VaultMusicHandler.stopBossLoop();
        type = VaultOverlayMessage.OverlayType.NONE;
        VaultGoalData.CURRENT_DATA = null;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientWorld == null || ServerVaults.isVaultWorld((ResourceKey<Level>)clientWorld.m_46472_()) || clientWorld.m_46472_() == VaultMod.ARENA_KEY) {
            return;
        }
        type = VaultOverlayMessage.OverlayType.NONE;
        modifiers = new VaultModifiers();
        inBossFight = false;
        VaultMusicHandler.stopBossLoop();
        VaultGoalData.CURRENT_DATA = null;
    }

    public static void receiveBossUpdate(BossMusicMessage bossMessage) {
        inBossFight = bossMessage.isInFight();
    }

    public static void receiveOverlayUpdate(VaultOverlayMessage overlayMessage) {
        remainingTicks = overlayMessage.getRemainingTicks();
        canGetRecordTime = overlayMessage.canGetRecordTime();
        type = overlayMessage.getOverlayType();
        showTimer = overlayMessage.showTimer();
    }

    public static void receiveModifierUpdate(VaultModifierMessage message) {
        modifiers = new VaultModifiers();
        message.getGlobalModifiers().stream().forEach(immutableVaultModifierStack -> modifiers.addPermanentModifier(immutableVaultModifierStack.getModifier(), immutableVaultModifierStack.getSize()));
        message.getPlayerModifiers().stream().forEach(immutableVaultModifierStack -> modifiers.addPermanentModifier(immutableVaultModifierStack.getModifier(), immutableVaultModifierStack.getSize()));
    }
}

