/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.MiningProperties;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ClientboundBountyCompleteMessage;
import iskallia.vault.world.data.BountyData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MiningTask
extends Task<MiningProperties> {
    public MiningTask(UUID bountyId, MiningProperties properties, TaskReward taskReward) {
        super(TaskRegistry.MINING, bountyId, properties, taskReward);
    }

    public MiningTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        block2: {
            VaultOreBlock block;
            block4: {
                block3: {
                    if (!(event instanceof BlockEvent.BreakEvent)) break block2;
                    BlockEvent.BreakEvent e = (BlockEvent.BreakEvent)event;
                    BlockState state = e.getState();
                    Block block2 = state.m_60734_();
                    if (!(block2 instanceof VaultOreBlock)) break block3;
                    block = (VaultOreBlock)block2;
                    if (((Boolean)state.m_61143_((Property)VaultOreBlock.GENERATED)).booleanValue()) break block4;
                }
                return false;
            }
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            return id != null && id.equals((Object)((MiningProperties)this.getProperties()).getBlockId());
        }
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((MiningProperties)this.getProperties()).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((MiningProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new MiningProperties(tag.m_128469_("properties"));
    }

    @SubscribeEvent
    public static void onOreBroken(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BountyData data = BountyData.get();
        data.getAllActiveTasksById(player2, TaskRegistry.MINING).stream().filter(task -> !task.isComplete()).filter(task -> task.validate(player2, event)).peek(task -> task.increment(1.0)).filter(Task::isComplete).forEach(task -> ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyCompleteMessage(task.taskType), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }
}

