/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.KillEntityProperties;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ClientboundBountyCompleteMessage;
import iskallia.vault.world.data.BountyData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class KillEntityTask
extends Task<KillEntityProperties> {
    public KillEntityTask(UUID bountyId, KillEntityProperties properties, TaskReward taskReward) {
        super(TaskRegistry.KILL_ENTITY, bountyId, properties, taskReward);
    }

    public KillEntityTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        if (!(event instanceof LivingDeathEvent)) {
            return false;
        }
        LivingDeathEvent e = (LivingDeathEvent)event;
        ResourceLocation entityId = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)e.getEntity().m_6095_());
        return entityId != null && entityId.equals((Object)((KillEntityProperties)this.getProperties()).getEntityId());
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((KillEntityProperties)this.properties).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((KillEntityProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new KillEntityProperties(tag.m_128469_("properties"));
    }

    @SubscribeEvent
    public static void onKillEntity(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BountyData data = BountyData.get();
        data.getAllActiveTasksById(player, TaskRegistry.KILL_ENTITY).stream().filter(task -> !task.isComplete()).filter(task -> task.validate(player, event)).peek(task -> task.increment(1.0)).filter(Task::isComplete).forEach(task -> ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyCompleteMessage(task.taskType), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }
}

