/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.block.BountyBlock;
import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.ItemSubmissionProperties;
import iskallia.vault.bounty.task.properties.TaskProperties;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ClientboundBountyCompleteMessage;
import iskallia.vault.world.data.BountyData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ItemSubmissionTask
extends Task<ItemSubmissionProperties> {
    public ItemSubmissionTask(UUID bountyId, ItemSubmissionProperties properties, TaskReward taskReward) {
        super(TaskRegistry.ITEM_SUBMISSION, bountyId, properties, taskReward);
    }

    public ItemSubmissionTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        if (!(event instanceof PlayerInteractEvent.RightClickBlock)) {
            return false;
        }
        PlayerInteractEvent.RightClickBlock e = (PlayerInteractEvent.RightClickBlock)event;
        Block block = e.getWorld().m_8055_(e.getPos()).m_60734_();
        if (e.getHand() != InteractionHand.MAIN_HAND) {
            return false;
        }
        if (!(block instanceof BountyBlock)) {
            return false;
        }
        BountyBlock bountyTable = (BountyBlock)block;
        ItemStack stack = e.getItemStack();
        Item item = stack.m_41720_();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
        return id != null && id.equals((Object)((ItemSubmissionProperties)this.getProperties()).getItemId());
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((ItemSubmissionProperties)this.getProperties()).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((ItemSubmissionProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new ItemSubmissionProperties(tag.m_128469_("properties"));
    }

    @SubscribeEvent
    public static void onInteractWithBountyTable(PlayerInteractEvent.RightClickBlock event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BountyData data = BountyData.get();
        data.getAllActiveTasksById(player, TaskRegistry.ITEM_SUBMISSION).stream().filter(task -> !task.isComplete()).filter(task -> task.validate(player, event)).peek(task -> {
            event.setCanceled(true);
            ItemStack stack = event.getItemStack();
            ItemStack match = event.getItemStack().m_41777_();
            int amount = stack.m_41613_();
            double remainder = Math.max(task.getAmountObtained() + (double)amount - ((TaskProperties)task.getProperties()).getAmount(), 0.0);
            task.increment((double)amount - remainder);
            stack.m_41764_((int)remainder);
            event.getPlayer().m_183503_().m_5594_(null, event.getPos(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.7f, ((event.getPlayer().m_21187_().nextFloat() - event.getPlayer().m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            if (remainder == 0.0) {
                Inventory inventory = event.getPlayer().m_150109_();
                int slot = inventory.m_36030_(match);
                if (slot < 0) {
                    return;
                }
                ItemStack newStack = inventory.m_8020_(slot).m_41777_();
                if (newStack.m_41619_()) {
                    return;
                }
                inventory.m_6836_(slot, ItemStack.f_41583_);
                inventory.m_6836_(event.getPlayer().m_150109_().f_35977_, newStack);
            }
        }).filter(Task::isComplete).forEach(task -> ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyCompleteMessage(task.taskType), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }
}

