/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.VaultMod;
import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.ItemDiscoveryProperties;
import iskallia.vault.core.event.common.ChestGenerationEvent;
import iskallia.vault.core.event.common.CoinStacksGenerationEvent;
import iskallia.vault.core.event.common.LootableBlockGenerationEvent;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ClientboundBountyCompleteMessage;
import iskallia.vault.world.data.BountyData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemDiscoveryTask
extends Task<ItemDiscoveryProperties> {
    private List<ItemStack> cachedItems;
    static long time = 0L;
    static int iterations = 100;
    static List<Long> times = new ArrayList<Long>();

    public ItemDiscoveryTask(UUID bountyId, ItemDiscoveryProperties properties, TaskReward taskReward) {
        super(TaskRegistry.ITEM_DISCOVERY, bountyId, properties, taskReward);
    }

    public ItemDiscoveryTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public void setCachedItems(List<ItemStack> cachedItems) {
        this.cachedItems = cachedItems;
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        if (this.cachedItems == null || this.cachedItems.isEmpty()) {
            return false;
        }
        for (ItemStack stack : this.cachedItems) {
            Item item = stack.m_41720_();
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
            ResourceLocation requiredItem = ((ItemDiscoveryProperties)this.getProperties()).getItemId();
            if (itemId == null || !itemId.equals((Object)requiredItem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((ItemDiscoveryProperties)this.getProperties()).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((ItemDiscoveryProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new ItemDiscoveryProperties(tag.m_128469_("properties"));
    }

    public static <T> void onLootGeneration(T event) {
        List<ItemStack> items;
        ServerPlayer player;
        time = System.currentTimeMillis();
        if (event instanceof ChestGenerationEvent.Data) {
            ChestGenerationEvent.Data e = (ChestGenerationEvent.Data)event;
            player = e.getPlayer();
            items = e.getLoot();
        } else if (event instanceof LivingDropsEvent) {
            LivingDropsEvent e = (LivingDropsEvent)event;
            if (!(e.getSource().m_7639_() instanceof ServerPlayer)) {
                return;
            }
            player = (ServerPlayer)e.getSource().m_7639_();
            items = e.getDrops().stream().map(ItemEntity::m_32055_).toList();
        } else if (event instanceof CoinStacksGenerationEvent.Data) {
            CoinStacksGenerationEvent.Data e = (CoinStacksGenerationEvent.Data)event;
            player = e.getPlayer();
            items = e.getLoot();
        } else if (event instanceof LootableBlockGenerationEvent.Data) {
            LootableBlockGenerationEvent.Data e = (LootableBlockGenerationEvent.Data)event;
            player = e.getPlayer();
            items = e.getLoot();
        } else {
            VaultMod.LOGGER.warn("Attempted to validate an unregistered event.");
            return;
        }
        BountyData data = BountyData.get();
        List activeTasks = data.getAllActiveTasksById(player, TaskRegistry.ITEM_DISCOVERY);
        block0: for (ItemDiscoveryTask task : activeTasks) {
            if (task.isComplete()) continue;
            task.setCachedItems(items);
            if (!task.validate(player, event)) continue;
            for (ItemStack stack : items) {
                Item item = stack.m_41720_();
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
                ResourceLocation requiredItem = ((ItemDiscoveryProperties)task.getProperties()).getItemId();
                if (itemId == null || !itemId.equals((Object)requiredItem)) continue;
                task.increment(stack.m_41613_());
                if (!task.isComplete()) continue;
                ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyCompleteMessage(task.taskType), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                continue block0;
            }
        }
        if (times.size() < iterations) {
            times.add(System.currentTimeMillis() - time);
        } else {
            long average = (long)times.stream().mapToLong(value -> value).average().orElse(0.0);
            VaultMod.LOGGER.debug("ItemDiscovery Last {} Iteration Time: {}ms", (Object)iterations, (Object)average);
            times.clear();
        }
    }
}

