/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty;

import com.google.gson.annotations.Expose;
import com.mojang.datafixers.util.Pair;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TaskReward
implements INBTSerializable<CompoundTag> {
    @Expose
    private int vaultExp;
    @Expose
    private List<ItemStack> rewardItems;
    @Expose
    private List<ResourceLocation> discoverModels;

    public TaskReward(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public TaskReward(int vaultExp, List<ItemStack> rewardItems) {
        this.vaultExp = vaultExp;
        this.rewardItems = rewardItems;
        this.discoverModels = new ArrayList<ResourceLocation>();
    }

    public TaskReward(int vaultExp, List<ItemStack> items, List<ResourceLocation> discoverModels) {
        this.vaultExp = vaultExp;
        this.rewardItems = items;
        this.discoverModels = discoverModels;
    }

    public void apply(ServerPlayer player) {
        PlayerVaultStatsData.get(player.m_183503_()).addVaultExp(player, this.vaultExp);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.createRewardCrate());
        player.f_36095_.m_38946_();
        if (this.discoverModels != null) {
            this.discoverModels.stream().map(ModDynamicModels.REGISTRIES::getModelAndAssociatedItem).filter(Optional::isPresent).map(Optional::get).forEach(itemPair -> this.discoverModel((Pair<? extends DynamicModel<?>, Item>)itemPair, player));
        }
    }

    private void discoverModel(Pair<? extends DynamicModel<?>, Item> itemPair, ServerPlayer player) {
        DiscoveredModelsData.get(player.m_183503_()).discoverModelAndBroadcast((Item)itemPair.getSecond(), ((DynamicModel)itemPair.getFirst()).getId(), (Player)player);
    }

    public ItemStack createRewardCrate() {
        NonNullList<ItemStack> rewardItemStacks = this.createRewardItems();
        return VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.BOUNTY, rewardItemStacks);
    }

    @Nonnull
    public NonNullList<ItemStack> createRewardItems() {
        NonNullList rewardItemStacks = NonNullList.m_122779_();
        this.rewardItems.forEach(stack -> rewardItemStacks.add((Object)stack.m_41777_()));
        return rewardItemStacks;
    }

    public int getVaultExp() {
        return this.vaultExp;
    }

    public List<ItemStack> getRewardItems() {
        return this.rewardItems;
    }

    public void setGearToPlayerLevel(ServerPlayer player) {
        for (ItemStack stack : this.rewardItems) {
            Item item;
            if (player != null && (item = stack.m_41720_()) instanceof VaultGearItem) {
                VaultGearItem gearItem = (VaultGearItem)item;
                gearItem.setPlayerLevel(stack, (Player)player);
            }
            DataTransferItem.doConvertStack(stack);
        }
    }

    public List<ResourceLocation> getDiscoverModels() {
        return this.discoverModels;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("vaultExp", this.vaultExp);
        NBTHelper.writeCollection(tag, "items", this.rewardItems, CompoundTag.class, IForgeItemStack::serializeNBT);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.vaultExp = tag.m_128451_("vaultExp");
        this.rewardItems = NBTHelper.readList(tag, "items", CompoundTag.class, ItemStack::m_41712_);
    }
}

