/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import iskallia.vault.block.entity.VaultRaidControllerTileEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class VaultRaidControllerRenderer
implements BlockEntityRenderer<VaultRaidControllerTileEntity> {
    private final Font font;

    public VaultRaidControllerRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    public void render(VaultRaidControllerTileEntity te, float partialTicks, PoseStack renderStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (te.didTriggerRaid()) {
            return;
        }
        this.drawHoveringModifiers(te.getModifierDisplay(), partialTicks, renderStack, buffer, combinedLight);
    }

    private void drawHoveringModifiers(List<Component> modifiers, float pTicks, PoseStack renderStack, MultiBufferSource buffer, int combinedLight) {
        EntityRenderDispatcher mgr = Minecraft.m_91087_().m_91290_();
        Font fr = this.font;
        renderStack.m_85836_();
        renderStack.m_85837_(0.5, 2.5, 0.5);
        renderStack.m_85845_(mgr.m_114470_());
        renderStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matr = renderStack.m_85850_().m_85861_();
        float textBgOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int textBgAlpha = (int)(textBgOpacity * 255.0f) << 24;
        for (Component modifier : modifiers) {
            float xShift = (float)fr.m_92852_((FormattedText)modifier) / 2.0f;
            fr.m_92841_(modifier, -xShift, 0.0f, 0x20FFFFFF, false, matr, buffer, true, textBgAlpha, combinedLight);
            fr.m_92841_(modifier, -xShift, 0.0f, -1, false, matr, buffer, false, 0, combinedLight);
            renderStack.m_85837_(0.0, -10.0, 0.0);
        }
        renderStack.m_85849_();
    }

    private boolean isInDrawDistance(BlockPos pos) {
        EntityRenderDispatcher mgr = Minecraft.m_91087_().m_91290_();
        return mgr.m_114378_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 4096.0;
    }
}

