/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.block.LootStatueBlock;
import iskallia.vault.block.entity.TrophyTileEntity;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.util.WeekKey;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TrophyRenderer
implements BlockEntityRenderer<TrophyTileEntity> {
    private final Minecraft mc = Minecraft.m_91087_();

    public TrophyRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TrophyTileEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState blockState = tileEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)LootStatueBlock.FACING);
        Minecraft mc = Minecraft.m_91087_();
        String latestNickname = tileEntity.getSkin().getLatestNickname();
        if (StringUtil.m_14408_((String)latestNickname)) {
            return;
        }
        this.drawRecordDisplay(matrixStack, buffer, direction, tileEntity, combinedLight, combinedOverlay);
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult result = (BlockHitResult)mc.f_91077_;
            if (tileEntity.m_58899_().equals((Object)result.m_82425_())) {
                MutableComponent text = new TextComponent(latestNickname).m_130940_(ChatFormatting.WHITE);
                TrophyRenderer.renderLabel(mc, matrixStack, buffer, combinedLight, (Component)text, -1);
            }
        }
    }

    static void renderLabel(Minecraft mc, PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, Component text, int color) {
        Font fontRenderer = mc.f_91062_;
        matrixStack.m_85836_();
        float scale = 0.02f;
        int opacity = 0x66000000;
        float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        matrixStack.m_85837_(0.5, (double)1.7f, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(mc.m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        fontRenderer.m_92841_(text, offset, 0.0f, color, false, matrix4f, buffer, true, opacity, lightLevel);
        fontRenderer.m_92841_(text, offset, 0.0f, -1, false, matrix4f, buffer, false, 0, lightLevel);
        matrixStack.m_85849_();
    }

    private void drawRecordDisplay(PoseStack matrixStack, MultiBufferSource buffer, Direction direction, TrophyTileEntity tileEntity, int combinedLight, int combinedOverlay) {
        if (tileEntity.isEmpty()) {
            return;
        }
        WeekKey week = tileEntity.getWeek();
        PlayerVaultStatsData.PlayerRecordEntry recordEntry = tileEntity.getRecordEntry();
        Font fr = this.mc.f_91062_;
        LocalDateTime ldt = LocalDateTime.now();
        ldt = ldt.with(IsoFields.WEEK_BASED_YEAR, week.getYear()).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, week.getWeek()).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        String from = ldt.getDayOfMonth() + "." + ldt.getMonthValue() + "." + ldt.getYear() + " -";
        ldt = ldt.with(TemporalAdjusters.next(DayOfWeek.SUNDAY));
        String to = ldt.getDayOfMonth() + "." + ldt.getMonthValue() + "." + ldt.getYear();
        FormattedCharSequence fromCmp = new TextComponent(from).m_7532_();
        FormattedCharSequence toCmp = new TextComponent(to).m_7532_();
        FormattedCharSequence timeStr = new TextComponent(UIHelper.formatTimeString(recordEntry.getTickCount())).m_7532_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(direction.m_122435_() + 180.0f));
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.24, 0.22);
        matrixStack.m_85841_(0.0055f, -0.0055f, 0.0055f);
        int xOffset = fr.m_92724_(fromCmp);
        fr.m_92733_(fromCmp, (float)(-xOffset) / 2.0f, 0.0f, -16777216, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, combinedLight);
        xOffset = fr.m_92724_(toCmp);
        fr.m_92733_(toCmp, (float)(-xOffset) / 2.0f, 10.0f, -16777216, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, combinedLight);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.1, 0.19);
        matrixStack.m_85841_(0.008f, -0.008f, 0.008f);
        xOffset = fr.m_92724_(timeStr);
        fr.m_92733_(timeStr, (float)(-xOffset) / 2.0f, 0.0f, -16777216, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, combinedLight);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }
}

