/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.ShopPedestalBlockTile;
import iskallia.vault.event.event.ShopPedestalPriceEvent;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ShopPedestalBlockTileRenderer
implements BlockEntityRenderer<ShopPedestalBlockTile> {
    private final ItemRenderer itemRenderer;
    private final Font font;

    public ShopPedestalBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
        this.font = minecraft.f_91065_.m_93082_();
    }

    public static void renderName(Component name, float h, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft mc = Minecraft.m_91087_();
        boolean i = false;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)h, 0.0);
        poseStack.m_85845_(mc.m_91290_().m_114470_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float f1 = mc.f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        float f2 = -mc.f_91062_.m_92852_((FormattedText)name) / 2;
        mc.f_91062_.m_92841_(name, f2, (float)i, -1, false, matrix4f, bufferIn, false, j, combinedLightIn);
        poseStack.m_85849_();
    }

    public void render(ShopPedestalBlockTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.isInitialized()) {
            return;
        }
        ItemStack offerStack = tile.getOfferStack();
        if (!offerStack.m_41619_()) {
            ItemStack currency;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                ShopPedestalPriceEvent event = new ShopPedestalPriceEvent((Player)player, offerStack, tile.getCurrencyStack());
                MinecraftForge.EVENT_BUS.post((Event)event);
                currency = event.getCost();
            } else {
                currency = tile.getCurrencyStack();
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            this.drawPrice(currency, matrixStack, buffer, String.valueOf(currency.m_41613_()), combinedLightIn, combinedOverlayIn);
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.625, 0.0);
            ShopPedestalBlockTileRenderer.renderName(offerStack.m_41786_(), 0.875f, matrixStack, buffer, combinedLightIn);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStack.m_85837_(0.0, 0.25, 0.0);
            ItemTransforms.TransformType transform = ItemTransforms.TransformType.FIXED;
            matrixStack.m_85837_(0.0, 0.375, 0.0);
            matrixStack.m_85841_(1.5f, 1.5f, 1.5f);
            long time = tile.m_58904_().m_46467_();
            int scale = 360;
            float angle = ((float)Math.floorMod(time, (long)scale) + partialTicks) / (float)scale;
            Quaternion rotation = Vector3f.f_122225_.m_122270_((float)((double)angle * Math.PI * 10.0));
            matrixStack.m_85845_(rotation);
            this.itemRenderer.m_174269_(offerStack, transform, combinedLightIn, combinedOverlayIn, matrixStack, buffer, 0);
            matrixStack.m_85849_();
            matrixStack.m_85849_();
        }
    }

    private void drawPrice(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, String name, int combinedLight, int combinedOverlay) {
        FormattedCharSequence text = new TextComponent(name).m_7532_();
        Font fr = this.font;
        int xOffset = fr.m_92724_(text);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            matrixStack.m_85836_();
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(dir.m_122435_()));
            matrixStack.m_85837_(0.0, 0.0, 0.4375);
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, -0.16, 0.075);
            matrixStack.m_85841_(0.6125f, 0.6125f, 0.6125f);
            this.itemRenderer.m_174269_(stack, ItemTransforms.TransformType.GROUND, combinedLight, combinedOverlay, matrixStack, buffer, 0);
            matrixStack.m_85849_();
            matrixStack.m_85837_(0.0, -0.25, 0.005);
            float scale = 0.015f;
            matrixStack.m_85841_(scale, -scale, scale);
            float f = 1.0f - (float)xOffset / 2.0f;
            Objects.requireNonNull(fr);
            fr.m_92733_(text, f, 1.0f - 9.0f / 2.0f, -16777216, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, combinedLight);
            matrixStack.m_85837_(0.0, 0.0, 0.001);
            float f2 = (float)(-xOffset) / 2.0f;
            Objects.requireNonNull(fr);
            fr.m_92733_(text, f2, (float)(-9) / 2.0f, -1, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, combinedLight);
            matrixStack.m_85849_();
        }
    }
}

