/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.block.base.FillableAltarTileEntity;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FillableAltarRenderer
implements BlockEntityRenderer<FillableAltarTileEntity> {
    private static final Vector3f FLUID_LOWER_POS = new Vector3f(2.25f, 2.0f, 2.25f);
    private static final Vector3f FLUID_UPPER_POS = new Vector3f(13.75f, 11.0f, 13.75f);

    public FillableAltarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FillableAltarTileEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlayIn) {
        if (!tileEntity.initialized()) {
            return;
        }
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
        float progressPercentage = tileEntity.progressPercentage();
        if (progressPercentage > 0.0f) {
            float fluidMaxHeight = FLUID_UPPER_POS.m_122260_() - FLUID_LOWER_POS.m_122260_();
            Vector3f upperPos = new Vector3f(FLUID_UPPER_POS.m_122239_(), FLUID_LOWER_POS.m_122260_() + fluidMaxHeight * progressPercentage, FLUID_UPPER_POS.m_122269_());
            this.renderCuboid(builder, matrixStack, FLUID_LOWER_POS, upperPos, tileEntity.getFillColor());
            if (buffer instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)buffer).m_109912_(RenderType.m_110466_());
            }
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91077_ != null && minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult result = (BlockHitResult)minecraft.f_91077_;
            if (tileEntity.m_58899_().equals((Object)result.m_82425_())) {
                TextComponent progressText = (TextComponent)(tileEntity.isMaxedOut() ? new TextComponent("Right Click to Loot!").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)-1313364))) : new TextComponent(tileEntity.getCurrentProgress() + " / " + tileEntity.getMaxProgress() + " ").m_7220_(tileEntity.getRequirementUnit()));
                this.renderLabel(matrixStack, 0.5f, 2.3f, 0.5f, buffer, combinedLight, tileEntity.getRequirementName());
                this.renderLabel(matrixStack, 0.5f, 2.1f, 0.5f, buffer, combinedLight, (Component)progressText);
            }
        }
    }

    public void renderLabel(PoseStack matrixStack, float x, float y, float z, MultiBufferSource buffer, int lightLevel, Component text) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        matrixStack.m_85836_();
        float scale = 0.02f;
        int opacity = 0x66000000;
        float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        matrixStack.m_85837_((double)x, (double)y, (double)z);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(minecraft.m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        fontRenderer.m_92841_(text, offset, 0.0f, -1, false, matrix4f, buffer, true, opacity, lightLevel);
        fontRenderer.m_92841_(text, offset, 0.0f, -1, false, matrix4f, buffer, false, 0, lightLevel);
        matrixStack.m_85849_();
    }

    public void renderCuboid(VertexConsumer builder, PoseStack matrixStack, Vector3f v1, Vector3f v2, Color tint) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(Fluids.f_76193_.getAttributes().getStillTexture());
        float minU = sprite.m_118367_(0.0);
        float maxU = sprite.m_118367_(16.0);
        float minV = sprite.m_118393_(0.0);
        float maxV = sprite.m_118393_(16.0);
        matrixStack.m_85836_();
        this.addVertex(builder, matrixStack, v1.m_122239_(), v2.m_122260_(), v1.m_122269_(), tint, minU, maxV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v2.m_122260_(), v2.m_122269_(), tint, minU, minV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v2.m_122260_(), v2.m_122269_(), tint, maxU, minV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v2.m_122260_(), v1.m_122269_(), tint, maxU, maxV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v1.m_122260_(), v1.m_122269_(), tint, minU, maxV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v2.m_122260_(), v1.m_122269_(), tint, minU, minV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v2.m_122260_(), v1.m_122269_(), tint, maxU, minV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v1.m_122260_(), v1.m_122269_(), tint, maxU, maxV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v1.m_122260_(), v1.m_122269_(), tint, minU, maxV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v2.m_122260_(), v1.m_122269_(), tint, minU, minV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v2.m_122260_(), v2.m_122269_(), tint, maxU, minV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v1.m_122260_(), v2.m_122269_(), tint, maxU, maxV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v1.m_122260_(), v2.m_122269_(), tint, minU, maxV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v2.m_122260_(), v2.m_122269_(), tint, minU, minV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v2.m_122260_(), v1.m_122269_(), tint, maxU, minV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v1.m_122260_(), v1.m_122269_(), tint, maxU, maxV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v1.m_122260_(), v2.m_122269_(), tint, minU, maxV);
        this.addVertex(builder, matrixStack, v2.m_122239_(), v2.m_122260_(), v2.m_122269_(), tint, minU, minV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v2.m_122260_(), v2.m_122269_(), tint, maxU, minV);
        this.addVertex(builder, matrixStack, v1.m_122239_(), v1.m_122260_(), v2.m_122269_(), tint, maxU, maxV);
        matrixStack.m_85849_();
    }

    public void addVertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, Color tint, float u, float v) {
        builder.m_85982_(matrixStack.m_85850_().m_85861_(), x / 16.0f, y / 16.0f, z / 16.0f).m_85950_((float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, 0.8f).m_7421_(u, v).m_7120_(0, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }
}

