/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.item;

import com.mojang.authlib.GameProfile;
import iskallia.vault.block.VaultChampionTrophy;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.McClientHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VaultChampionTrophyBlockItem
extends BlockItem {
    public static final String NBT_OWNER_UUID = "OwnerUUID";
    public static final String NBT_OWNER_NICK = "OwnerNickname";
    public static final String NBT_VARIANT = "Variant";

    public VaultChampionTrophyBlockItem(Block block) {
        super(block, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)VaultChampionTrophyBlockItem.create(null, VaultChampionTrophy.Variant.GOLDEN));
            items.add((Object)VaultChampionTrophyBlockItem.create(null, VaultChampionTrophy.Variant.PLATINUM));
            items.add((Object)VaultChampionTrophyBlockItem.create(null, VaultChampionTrophy.Variant.BLUE_SILVER));
            items.add((Object)VaultChampionTrophyBlockItem.create(null, VaultChampionTrophy.Variant.SILVER));
        }
    }

    public void m_6883_(@Nonnull ItemStack itemStack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        CompoundTag blockEntityTag = itemStack.m_41698_("BlockEntityTag");
        if (blockEntityTag.m_128441_(NBT_OWNER_UUID)) {
            return;
        }
        blockEntityTag.m_128359_(NBT_OWNER_UUID, player.m_142081_().toString());
        blockEntityTag.m_128359_(NBT_OWNER_NICK, player.m_7755_().getString());
        super.m_6883_(itemStack, world, entity, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        CompoundTag blockEntityTag = stack.m_41698_("BlockEntityTag");
        String uuidString = blockEntityTag.m_128461_(NBT_OWNER_UUID);
        UUID ownerUUID = uuidString.isEmpty() ? null : UUID.fromString(uuidString);
        String ownerNickname = McClientHelper.getOnlineProfile(ownerUUID).map(GameProfile::getName).orElse(blockEntityTag.m_128461_(NBT_OWNER_NICK));
        MutableComponent titleText = new TextComponent("Vault Champion").m_130940_(ChatFormatting.GOLD);
        MutableComponent championText = new TextComponent("Mighty " + ownerNickname).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD);
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)titleText);
        tooltip.add((Component)championText);
    }

    public static ItemStack create(ServerPlayer owner, VaultChampionTrophy.Variant variant) {
        return VaultChampionTrophyBlockItem.create(owner == null ? null : owner.m_142081_(), owner == null ? null : owner.m_7755_().getString(), variant);
    }

    public static ItemStack create(UUID ownerUUID, String ownerNickname, VaultChampionTrophy.Variant variant) {
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.VAULT_CHAMPION_TROPHY_BLOCK_ITEM);
        CompoundTag nbt = itemStack.m_41784_();
        CompoundTag blockEntityTag = itemStack.m_41698_("BlockEntityTag");
        if (ownerUUID != null) {
            blockEntityTag.m_128359_(NBT_OWNER_UUID, ownerUUID.toString());
        }
        if (ownerNickname != null) {
            blockEntityTag.m_128359_(NBT_OWNER_NICK, ownerNickname);
        }
        blockEntityTag.m_128359_(NBT_VARIANT, variant.m_7912_());
        nbt.m_128405_("CustomModelData", variant.ordinal());
        return itemStack;
    }
}

