/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.StabilizerBlock;
import iskallia.vault.block.VaultRaidControllerBlock;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.objective.raid.modifier.ModifierDoublingModifier;
import iskallia.vault.world.vault.logic.objective.raid.modifier.RaidModifier;
import iskallia.vault.world.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VaultRaidControllerTileEntity
extends BlockEntity {
    private static final Random rand = new Random();
    private static final AABB RENDER_BOX = new AABB(-1.0, -1.0, -1.0, 1.0, 2.0, 1.0);
    private boolean triggeredRaid = false;
    private int activeTimeout = 0;
    private final LinkedHashMap<String, Float> raidModifiers = new LinkedHashMap();
    private final List<Object> particleReferences = new ArrayList<Object>();

    public VaultRaidControllerTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.RAID_CONTROLLER_TILE_ENTITY, pos, state);
    }

    public boolean isActive() {
        return this.activeTimeout > 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VaultRaidControllerTileEntity tile) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState up = level.m_8055_(pos.m_7494_());
            if (!(up.m_60734_() instanceof VaultRaidControllerBlock)) {
                level.m_46597_(pos.m_7494_(), (BlockState)ModBlocks.RAID_CONTROLLER_BLOCK.m_49966_().m_61124_(StabilizerBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
            }
            if (tile.activeTimeout > 0) {
                --tile.activeTimeout;
                if (tile.activeTimeout <= 0) {
                    tile.markForUpdate();
                }
            }
        } else {
            tile.setupParticles();
        }
    }

    private void generateModifiers(VaultRaid vault) {
        boolean cannotGetArtifact = vault.hasActiveModifierFor(PlayerFilter.any(), PlayerInventoryRestoreModifier.class, m -> ((PlayerInventoryRestoreModifier.Properties)m.properties()).preventsArtifact());
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        RaidModifier addedModifier = ModConfigs.RAID_MODIFIER_CONFIG.getRandomModifier(level, true, cannotGetArtifact).map(modifier -> {
            RaidModifier mod = modifier.getModifier();
            if (mod != null) {
                this.raidModifiers.put(mod.getName(), Float.valueOf(modifier.getRandomValue()));
            }
            return mod;
        }).orElse(null);
        if (addedModifier != null && !(addedModifier instanceof ModifierDoublingModifier)) {
            ModConfigs.RAID_MODIFIER_CONFIG.getRandomModifier(level, false, cannotGetArtifact).ifPresent(modifier -> {
                RaidModifier mod = modifier.getModifier();
                if (mod != null) {
                    this.raidModifiers.put(mod.getName(), Float.valueOf(modifier.getRandomValue()));
                }
            });
        }
        this.markForUpdate();
    }

    private void generateModifiersFinal(VaultRaid vault) {
        boolean cannotGetArtifact = vault.hasActiveModifierFor(PlayerFilter.any(), PlayerInventoryRestoreModifier.class, m -> ((PlayerInventoryRestoreModifier.Properties)m.properties()).preventsArtifact());
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        ModConfigs.FINAL_RAID_MODIFIER_CONFIG.getRandomModifier(level, cannotGetArtifact).ifPresent(modifier -> {
            RaidModifier mod = modifier.getModifier();
            if (mod != null) {
                this.raidModifiers.put(mod.getName(), Float.valueOf(modifier.getRandomValue()));
            }
        });
        this.markForUpdate();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupParticles() {
        if (this.particleReferences.size() < 3) {
            int toAdd = 3 - this.particleReferences.size();
            for (int i = 0; i < toAdd; ++i) {
                ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
                Particle p = mgr.m_107370_((ParticleOptions)ModParticles.RAID_EFFECT_CUBE.get(), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                this.particleReferences.add(p);
            }
        }
        this.particleReferences.removeIf(ref -> !((Particle)ref).m_107276_());
        if (!this.isActive()) {
            return;
        }
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        Color c = new Color(11932948);
        if (rand.nextInt(3) == 0) {
            Vec3 pPos = new Vec3((double)this.f_58858_.m_123341_() + 0.5 + (double)rand.nextFloat() * 3.5 * (double)(rand.nextBoolean() ? 1 : -1), (double)this.f_58858_.m_123342_() + 2.1 + (double)rand.nextFloat() * 3.5 * (double)(rand.nextBoolean() ? 1 : -1), (double)this.f_58858_.m_123343_() + 0.5 + (double)rand.nextFloat() * 3.5 * (double)(rand.nextBoolean() ? 1 : -1));
            SimpleAnimatedParticle fwParticle = (SimpleAnimatedParticle)mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, pPos.m_7096_(), pPos.m_7098_(), pPos.m_7094_(), 0.0, 0.0, 0.0);
            fwParticle.m_107253_((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            fwParticle.m_107257_(fwParticle.m_107273_() / 2);
            pPos = new Vec3((double)this.f_58858_.m_123341_() + 0.5 + (double)rand.nextFloat() * 0.3 * (double)(rand.nextBoolean() ? 1 : -1), (double)this.f_58858_.m_123342_() + 2.25 + (double)rand.nextFloat() * 0.3 * (double)(rand.nextBoolean() ? 1 : -1), (double)this.f_58858_.m_123343_() + 0.5 + (double)rand.nextFloat() * 0.3 * (double)(rand.nextBoolean() ? 1 : -1));
            fwParticle = (SimpleAnimatedParticle)mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, pPos.m_7096_(), pPos.m_7098_(), pPos.m_7094_(), 0.0, 0.0, 0.0);
            fwParticle.m_107253_((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        }
    }

    private void markForUpdate() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.m_6596_();
        }
    }

    public boolean didTriggerRaid() {
        return this.triggeredRaid;
    }

    public void setTriggeredRaid(boolean triggeredRaid) {
        this.triggeredRaid = triggeredRaid;
        this.markForUpdate();
    }

    public LinkedHashMap<String, Float> getRaidModifiers() {
        return this.raidModifiers;
    }

    public List<Component> getModifierDisplay() {
        return this.raidModifiers.entrySet().stream().map(modifierEntry -> {
            RaidModifier modifier = ModConfigs.RAID_MODIFIER_CONFIG.getByName((String)modifierEntry.getKey());
            if (modifier == null) {
                return null;
            }
            return new Tuple((Object)modifier, (Object)((Float)modifierEntry.getValue()));
        }).filter(Objects::nonNull).map(tpl -> ((RaidModifier)tpl.m_14418_()).getDisplay(((Float)tpl.m_14419_()).floatValue())).collect(Collectors.toList());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.activeTimeout = pTag.m_128451_("timeout");
        this.triggeredRaid = pTag.m_128471_("triggeredRaid");
        this.raidModifiers.clear();
        ListTag modifiers = pTag.m_128437_("raidModifiers", 10);
        for (int i = 0; i < modifiers.size(); ++i) {
            CompoundTag modifierTag = modifiers.m_128728_(i);
            String modifier = modifierTag.m_128461_("name");
            float value = modifierTag.m_128457_("value");
            this.raidModifiers.put(modifier, Float.valueOf(value));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("timeout", this.activeTimeout);
        pTag.m_128379_("triggeredRaid", this.triggeredRaid);
        ListTag modifiers = new ListTag();
        this.raidModifiers.forEach((modifier, value) -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("name", modifier);
            nbt.m_128350_("value", value.floatValue());
            modifiers.add((Object)nbt);
        });
        pTag.m_128365_("raidModifiers", (Tag)modifiers);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public AABB getRenderBoundingBox() {
        return RENDER_BOX.m_82338_(this.m_58899_());
    }
}

