/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.google.common.collect.Lists;
import iskallia.vault.VaultMod;
import iskallia.vault.container.VaultDiffuserContainer;
import iskallia.vault.container.base.SimpleSidedContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.network.message.DiffuserParticleMessage;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class VaultDiffuserTileEntity
extends BlockEntity
implements MenuProvider {
    private static final Random rand = new Random();
    private static final BlockPos[] list = new BlockPos[]{BlockPos.f_121853_.m_142127_().m_142126_(), BlockPos.f_121853_.m_142127_().m_142125_(), BlockPos.f_121853_.m_142128_().m_142126_(), BlockPos.f_121853_.m_142128_().m_142125_()};
    private final DiffuserInventory inventory = new DiffuserInventory();
    private ItemStack prevInput = ItemStack.f_41583_;
    private int processTick = 0;
    private int processTickLast = 0;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH});
    private LazyOptional<? extends IItemHandler>[] outputHandlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.DOWN});

    public VaultDiffuserTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.VAULT_DIFFUSER_ENTITY, pWorldPosition, pBlockState);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, VaultDiffuserTileEntity tile) {
        tile.processTickLast = tile.processTick;
        if (!tile.prevInput.m_41656_(tile.inventory.m_8020_(0))) {
            tile.triggerItemChange();
        }
        tile.prevInput = tile.inventory.m_8020_(0);
        if (world.m_5776_()) {
            float f2;
            float f1;
            float f;
            Vec3 vec3;
            if (tile.getProgressPercent() > 0.0f && tile.getProgressPercent() < 0.3f) {
                vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.65, (double)pos.m_123343_() + 0.5);
                for (BlockPos blockpos : list) {
                    f = (float)blockpos.m_123341_() / 3.5f;
                    f1 = 0.5f;
                    f2 = (float)blockpos.m_123343_() / 3.5f;
                    world.m_7106_((ParticleOptions)ModParticles.REVERSE_DIFFUSER.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
                }
            }
            if (tile.getProgressPercent() > 0.6f && tile.getProgressPercent() < 0.9f) {
                vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.75, (double)pos.m_123343_() + 0.5);
                for (BlockPos blockpos : list) {
                    f = (float)blockpos.m_123341_() / 2.5f;
                    f1 = 1.0f;
                    f2 = (float)blockpos.m_123343_() / 2.5f;
                    world.m_7106_((ParticleOptions)ModParticles.DIFFUSER.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
                }
            }
        }
        if (world.m_5776_()) {
            return;
        }
        if (!tile.canCraft()) {
            tile.resetProcess(world);
            return;
        }
        if (tile.processTick == 0 && tile.f_58857_ != null) {
            tile.f_58857_.m_5594_(null, tile.m_58899_(), SoundEvents.f_11767_, SoundSource.BLOCKS, 0.5f + new Random().nextFloat() * 0.05f, 0.85f + new Random().nextFloat() * 0.05f);
        }
        ++tile.processTick;
        if (tile.processTick >= ModConfigs.VAULT_DIFFUSER.getProcessingTickTime()) {
            tile.finishCraft();
        }
        tile.m_6596_();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7260_(pos, state, state, 3);
        }
    }

    private void finishCraft() {
        int output = this.getRecipeOutput();
        if (output == 0) {
            return;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11739_, SoundSource.BLOCKS, 0.5f + new Random().nextFloat() * 0.05f, 0.85f + new Random().nextFloat() * 0.05f);
        }
        this.processTick = 0;
        ItemStack input = this.inventory.m_8020_(0).m_41777_();
        this.inventory.m_7407_(0, 1);
        List<ItemStack> stacksToAdd = this.getUseRelatedOutput(ModConfigs.VAULT_DIFFUSER.generateOutput(output));
        stacksToAdd.forEach(this.inventory::m_19173_);
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new DiffuserParticleMessage(this.m_58899_()));
    }

    private List<ItemStack> getUseRelatedOutput(List<ItemStack> output) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        output.forEach(stack -> {
            float out = stack.m_41613_();
            int resultCount = Mth.m_14143_((float)out);
            if (resultCount < 1 && out > 0.0f && rand.nextFloat() < out) {
                ++resultCount;
            }
            ItemStack copyOut = stack.m_41777_();
            copyOut.m_41764_(resultCount);
            list.add(copyOut);
        });
        return list;
    }

    private boolean canCraft() {
        int output = this.getRecipeOutput();
        if (output == 0) {
            return false;
        }
        return this.canAddItem(output);
    }

    private boolean canAddItem(int count) {
        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ModConfigs.VAULT_DIFFUSER.getOutputItem()));
        int openSpace = 0;
        for (int i = 1; i < this.inventory.m_6643_(); ++i) {
            ItemStack slotItem = this.inventory.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)slotItem, (ItemStack)stack) && !slotItem.m_41619_()) continue;
            if (slotItem.m_41619_()) {
                openSpace += 64;
                continue;
            }
            openSpace += 64 - slotItem.m_41613_();
        }
        return openSpace >= count;
    }

    @Nullable
    private int getRecipeOutput() {
        ItemStack input = this.inventory.m_8020_(0);
        if (!this.isValidInput(input)) {
            return 0;
        }
        int output = ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().containsKey(input.m_41720_().getRegistryName()) ? ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().get(input.m_41720_().getRegistryName()).intValue() : ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().get(VaultMod.id("default")).intValue();
        return output;
    }

    private void triggerItemChange() {
        ItemStack input = this.inventory.m_8020_(0).m_41777_();
        if (!this.isValidInput(input) && !input.m_41656_(this.prevInput)) {
            this.resetProcess(null);
            return;
        }
        if (this.canCraft()) {
            this.startProcess(null);
        }
    }

    public boolean isValidInput(ItemStack input) {
        if (input.m_41619_()) {
            return false;
        }
        return ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().containsKey(input.m_41720_().getRegistryName());
    }

    private void resetProcess(@Nullable Level world) {
        this.startProcess(world);
    }

    private void startProcess(@Nullable Level world) {
        int prevTick = this.processTick;
        this.processTick = 0;
        this.m_6596_();
        if (prevTick != this.processTick && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float getProgressPercent() {
        return (float)this.processTick / (float)ModConfigs.VAULT_DIFFUSER.getProcessingTickTime();
    }

    public float getProgressLastPercent() {
        return (float)this.processTickLast / (float)ModConfigs.VAULT_DIFFUSER.getProcessingTickTime();
    }

    public DiffuserInventory getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        NBTHelper.deserializeSimpleContainer(this.inventory, tag.m_128437_("inventory", 10));
        this.processTick = tag.m_128451_("processTick");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)NBTHelper.serializeSimpleContainer(this.inventory));
        tag.m_128405_("processTick", this.processTick);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultDiffuserContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.EAST) {
                return this.handlers[1].cast();
            }
            if (facing == Direction.NORTH) {
                return this.handlers[2].cast();
            }
            if (facing == Direction.WEST) {
                return this.handlers[3].cast();
            }
            if (facing == Direction.SOUTH) {
                return this.handlers[4].cast();
            }
            if (facing == Direction.DOWN) {
                return this.outputHandlers[0].cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        Arrays.stream(this.handlers).forEach(LazyOptional::invalidate);
        Arrays.stream(this.outputHandlers).forEach(LazyOptional::invalidate);
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH});
        this.outputHandlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.DOWN});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnDiffuserParticles(BlockPos pos) {
        Vec3 offset;
        float length;
        float rotation;
        Random random;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (i = 0; i < 40; ++i) {
            random = level.m_5822_();
            rotation = random.nextFloat() * 360.0f;
            length = random.nextFloat() / 5.0f + 0.1f;
            offset = new Vec3(Math.cos(rotation) * (double)length, 0.0, Math.sin(rotation) * (double)length);
            level.m_6493_((ParticleOptions)ModParticles.DIFFUSER_COMPLETE.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_ / 20.0, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 1.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_ / 20.0, offset.f_82479_ * 2.0, 0.01, offset.f_82481_ * 2.0);
        }
        for (i = 0; i < 20; ++i) {
            random = level.m_5822_();
            rotation = random.nextFloat() * 360.0f;
            length = random.nextFloat() / 5.0f + 0.1f;
            offset = new Vec3(Math.cos(rotation) * (double)length, 0.0, Math.sin(rotation) * (double)length);
            level.m_6493_((ParticleOptions)ModParticles.DIFFUSER_COMPLETE.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_ / 20.0, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 1.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_ / 20.0, offset.f_82479_ * 3.0, 0.01, offset.f_82481_ * 3.0);
        }
        for (i = 0; i < 20; ++i) {
            random = level.m_5822_();
            rotation = random.nextFloat() * 360.0f;
            length = (random.nextFloat() + 0.1f) / 25.0f;
            offset = new Vec3(Math.cos(rotation) * (double)length, 0.0, Math.sin(rotation) * (double)length);
            level.m_6493_((ParticleOptions)ModParticles.DIFFUSER_COMPLETE.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_ / 20.0, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 1.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_ / 20.0, offset.f_82479_ * 3.0, (random.nextDouble() * 0.3 + 0.25) * (double)(random.nextBoolean() ? -1 : 1), offset.f_82481_ * 3.0);
        }
    }

    public class DiffuserInventory
    extends SimpleSidedContainer {
        public DiffuserInventory() {
            super(6);
        }

        @Override
        public List<Direction> getAccessibleSlots(int slot) {
            if (slot == 0) {
                return Lists.newArrayList((Object[])new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH});
            }
            return Lists.newArrayList((Object[])new Direction[]{Direction.DOWN});
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().containsKey(stack.m_41720_().getRegistryName());
        }

        public void m_6596_() {
            super.m_6596_();
            VaultDiffuserTileEntity.this.m_6596_();
        }

        public ItemStack m_19173_(ItemStack pStack) {
            ItemStack $$1 = pStack.m_41777_();
            this.moveItemToOccupiedSlotsWithSameType($$1);
            if ($$1.m_41619_()) {
                return ItemStack.f_41583_;
            }
            this.moveItemToEmptySlots($$1);
            return $$1.m_41619_() ? ItemStack.f_41583_ : $$1;
        }

        private void moveItemToEmptySlots(ItemStack pStack) {
            for (int $$1 = 1; $$1 < this.m_6643_(); ++$$1) {
                ItemStack $$2 = this.m_8020_($$1);
                if (!$$2.m_41619_()) continue;
                this.m_6836_($$1, pStack.m_41777_());
                pStack.m_41764_(0);
                return;
            }
        }

        private void moveItemToOccupiedSlotsWithSameType(ItemStack pStack) {
            for (int $$1 = 1; $$1 < this.m_6643_(); ++$$1) {
                ItemStack $$2 = this.m_8020_($$1);
                if (!ItemStack.m_150942_((ItemStack)$$2, (ItemStack)pStack)) continue;
                this.moveItemsBetweenStacks(pStack, $$2);
                if (!pStack.m_41619_()) continue;
                return;
            }
        }

        private void moveItemsBetweenStacks(ItemStack p_19186_, ItemStack p_19187_) {
            int $$2 = Math.min(this.m_6893_(), p_19187_.m_41741_());
            int $$3 = Math.min(p_19186_.m_41613_(), $$2 - p_19187_.m_41613_());
            if ($$3 > 0) {
                p_19187_.m_41769_($$3);
                p_19186_.m_41774_($$3);
                this.m_6596_();
            }
        }
    }
}

