/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.init.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class VaultCrateTileEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public VaultCrateTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VAULT_CRATE_TILE_ENTITY, pos, state);
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        pTag.m_128469_("inv").m_128473_("Size");
        this.itemHandler.deserializeNBT(pTag.m_128469_("inv"));
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(54){

            protected void onContentsChanged(int slot) {
                VaultCrateTileEntity.this.sendUpdates();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (!stack.m_41720_().m_142095_()) {
                    return false;
                }
                return !(Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock) && !(Block.m_49814_((Item)stack.m_41720_()) instanceof VaultCrateBlock);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundTag saveToNbt() {
        return this.itemHandler.serializeNBT();
    }

    public void loadFromNBT(CompoundTag nbt) {
        this.itemHandler.deserializeNBT(nbt);
    }
}

