/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.google.common.collect.Lists;
import com.mojang.math.Vector3f;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.ChestGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.loot.generator.TieredLootTableGenerator;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.util.calc.ItemQuantityHelper;
import iskallia.vault.util.calc.ItemRarityHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class VaultChestTileEntity
extends ChestBlockEntity {
    private VaultRarity rarity;
    private boolean generated;
    private int size;
    private BlockState renderState;
    private int ticksSinceSync;

    protected VaultChestTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.size = this.getSize(state);
        this.m_6520_(NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_));
    }

    private int getSize(BlockState state) {
        if (state.m_60734_() == ModBlocks.TREASURE_CHEST || state.m_60734_() == ModBlocks.TREASURE_CHEST_PLACEABLE) {
            return 54;
        }
        if (state.m_60734_() == ModBlocks.ORNATE_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.GILDED_CHEST_PLACEABLE) {
            return 36;
        }
        if (state.m_60734_() == ModBlocks.LIVING_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.ALTAR_CHEST_PLACEABLE) {
            return 45;
        }
        return 27;
    }

    public int m_6643_() {
        return this.size;
    }

    public VaultChestTileEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.VAULT_CHEST_TILE_ENTITY, pos, state);
    }

    @Nullable
    public VaultRarity getRarity() {
        return this.rarity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderState(BlockState renderState) {
        this.renderState = renderState;
    }

    public void m_5856_(Player player) {
        super.m_5856_(player);
        this.playVaultChestSound();
    }

    public static <E extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, VaultChestTileEntity tile) {
        ChestBlockEntity.m_155343_((Level)level, (BlockPos)pos, (BlockState)state, (ChestBlockEntity)tile);
        tile.addParticles();
    }

    private void playVaultChestSound() {
        if (this.f_58857_ == null || this.rarity == null) {
            return;
        }
        double x = (double)this.f_58858_.m_123341_() + 0.5;
        double y = (double)this.f_58858_.m_123342_() + 0.5;
        double z = (double)this.f_58858_.m_123343_() + 0.5;
        switch (this.rarity) {
            case RARE: {
                this.f_58857_.m_6263_(null, x, y, z, ModSounds.VAULT_CHEST_RARE_OPEN, SoundSource.BLOCKS, 0.2f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case EPIC: {
                this.f_58857_.m_6263_(null, x, y, z, ModSounds.VAULT_CHEST_EPIC_OPEN, SoundSource.BLOCKS, 0.2f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case OMEGA: {
                this.f_58857_.m_6263_(null, x, y, z, ModSounds.VAULT_CHEST_OMEGA_OPEN, SoundSource.BLOCKS, 0.2f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    private void addParticles() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.rarity == null || this.rarity == VaultRarity.COMMON || this.rarity == VaultRarity.RARE) {
            return;
        }
        float xx = this.f_58857_.f_46441_.nextFloat() * 2.0f - 1.0f;
        float zz = this.f_58857_.f_46441_.nextFloat() * 2.0f - 1.0f;
        double x = (double)this.f_58858_.m_123341_() + 0.5 + 0.7 * (double)xx;
        double y = (float)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.nextFloat();
        double z = (double)this.f_58858_.m_123343_() + 0.5 + 0.7 * (double)zz;
        double xSpeed = this.f_58857_.f_46441_.nextFloat() * xx;
        double ySpeed = ((double)this.f_58857_.f_46441_.nextFloat() - 0.5) * 0.25;
        double zSpeed = this.f_58857_.f_46441_.nextFloat() * zz;
        float red = this.rarity == VaultRarity.EPIC ? 1.0f : 0.0f;
        float green = this.rarity == VaultRarity.OMEGA ? 1.0f : 0.0f;
        float blue = this.rarity == VaultRarity.EPIC ? 1.0f : 0.0f;
        this.f_58857_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(red, green, blue), 1.0f), x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_59640_(Player player) {
        this.generateChestLoot(player, false);
    }

    public void generateChestLoot(Player source, boolean compress) {
        ServerPlayer player;
        block6: {
            block5: {
                if (this.m_58904_() == null || this.m_58904_().m_5776_() || !(source instanceof ServerPlayer)) break block5;
                player = (ServerPlayer)source;
                if (!this.generated) break block6;
            }
            return;
        }
        if (MiscUtils.isPlayerFakeMP(player) || source.m_5833_()) {
            this.generated = true;
            this.m_6596_();
            return;
        }
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        ChestGenerationEvent.Data data = CommonEvents.CHEST_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.f_59605_, this, loot, this.rarity, Version.latest(), JavaRandom.ofNanoTime(), ChestGenerationEvent.Phase.PRE);
        this.f_59605_ = data.getLootTable();
        if (this.f_59605_ == null) {
            this.generated = true;
            this.m_6596_();
            return;
        }
        this.generateLootTable(source, loot, data.getRandom());
        CommonEvents.CHEST_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.f_59605_, this, loot, this.rarity, data.getVersion(), data.getRandom(), ChestGenerationEvent.Phase.POST);
        this.fillLoot(loot, compress, data.getRandom());
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        this.generated = true;
    }

    private void generateLootTable(@Nullable Player player, List<ItemStack> loot, RandomSource random) {
        float quantity = ItemQuantityHelper.getItemQuantity((LivingEntity)player);
        float rarity = ItemRarityHelper.getItemRarity((LivingEntity)player);
        LootTableKey key = VaultRegistry.LOOT_TABLE.getKey(this.f_59605_);
        if (key != null) {
            TieredLootTableGenerator generator = new TieredLootTableGenerator(Version.latest(), key, rarity, quantity);
            generator.source = player;
            generator.generate(random);
            this.rarity = ModConfigs.VAULT_CHEST.getRarity(generator.getCDF());
            generator.getItems().forEachRemaining(loot::add);
        } else {
            this.rarity = VaultRarity.COMMON;
        }
        this.m_6596_();
    }

    public void fillLoot(List<ItemStack> loot, boolean compress, RandomSource random) {
        if (compress) {
            List<ItemStack> mergedLoot = MiscUtils.splitAndLimitStackSize(MiscUtils.mergeItemStacks(loot));
            mergedLoot.forEach(stack -> MiscUtils.addItemStack((Container)this, stack));
            this.m_6596_();
            return;
        }
        List<Integer> slots = this.getAvailableSlots((Container)this, random);
        this.shuffleAndSplitItems(loot, slots.size(), random);
        for (ItemStack itemstack : loot) {
            if (slots.isEmpty()) break;
            this.m_6836_(slots.remove(slots.size() - 1), itemstack.m_41619_() ? ItemStack.f_41583_ : itemstack);
        }
        this.m_6596_();
    }

    private List<Integer> getAvailableSlots(Container pInventory, RandomSource pRand) {
        int i;
        ArrayList list = Lists.newArrayList();
        for (i = 0; i < pInventory.m_6643_(); ++i) {
            if (!pInventory.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        for (i = list.size(); i > 1; --i) {
            int index = pRand.nextInt(i);
            int temp = (Integer)list.get(i - 1);
            list.set(i - 1, (Integer)list.get(index));
            list.set(index, temp);
        }
        return list;
    }

    private void shuffleAndSplitItems(List<ItemStack> pStacks, int pEmptySlotsCount, RandomSource random) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = pStacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (pEmptySlotsCount - pStacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(random.nextInt(list.size()));
            int i = random.nextInt(1, itemstack2.m_41613_() / 2 + 1);
            ItemStack itemstack1 = itemstack2.m_41620_(i);
            if (itemstack2.m_41613_() > 1 && random.nextBoolean()) {
                list.add(itemstack2);
            } else {
                pStacks.add(itemstack2);
            }
            if (itemstack1.m_41613_() > 1 && random.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            pStacks.add(itemstack1);
        }
        pStacks.addAll(list);
        for (int i = list.size(); i > 1; --i) {
            int index = random.nextInt(i);
            ItemStack temp = pStacks.get(i - 1);
            pStacks.set(i - 1, pStacks.get(index));
            pStacks.set(index, temp);
        }
    }

    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = super.m_7407_(index, count);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = super.m_8016_(index);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return stack;
    }

    public BlockState m_58900_() {
        if (this.renderState != null) {
            return this.renderState;
        }
        return super.m_58900_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("Rarity", 3)) {
            this.rarity = VaultRarity.values()[nbt.m_128451_("Rarity")];
        }
        this.generated = nbt.m_128471_("Generated");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.rarity != null) {
            pTag.m_128405_("Rarity", this.rarity.ordinal());
        }
        pTag.m_128379_("Generated", this.generated);
    }

    public Component m_5446_() {
        if (this.rarity != null) {
            String rarity = StringUtils.capitalize((String)this.rarity.name().toLowerCase());
            BlockState state = this.m_58900_();
            if (state.m_60734_() == ModBlocks.WOODEN_CHEST || state.m_60734_() == ModBlocks.WOODEN_CHEST_PLACEABLE) {
                return new TextComponent(rarity + " Wooden Chest");
            }
            if (state.m_60734_() == ModBlocks.GILDED_CHEST || state.m_60734_() == ModBlocks.GILDED_CHEST_PLACEABLE) {
                return new TextComponent(rarity + " Gilded Chest");
            }
            if (state.m_60734_() == ModBlocks.LIVING_CHEST || state.m_60734_() == ModBlocks.LIVING_CHEST_PLACEABLE) {
                return new TextComponent(rarity + " Living Chest");
            }
            if (state.m_60734_() == ModBlocks.ORNATE_CHEST || state.m_60734_() == ModBlocks.ORNATE_CHEST_PLACEABLE) {
                return new TextComponent(rarity + " Ornate Chest");
            }
            if (state.m_60734_() == ModBlocks.TREASURE_CHEST || state.m_60734_() == ModBlocks.TREASURE_CHEST_PLACEABLE) {
                return new TextComponent(rarity + " Treasure Chest");
            }
            if (state.m_60734_() == ModBlocks.ALTAR_CHEST || state.m_60734_() == ModBlocks.ALTAR_CHEST_PLACEABLE) {
                return new TextComponent(rarity + " Altar Chest");
            }
        }
        return super.m_5446_();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

