/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.data.PlayerVaultAltarData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class VaultAltarTileEntity
extends BlockEntity {
    private UUID owner;
    private AltarInfusionRecipe recipe;
    private AltarState altarState;
    private HashMap<String, Integer> displayedIndex = new HashMap();
    private int infusionTimer = -666;

    public VaultAltarTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VAULT_ALTAR_TILE_ENTITY, pos, state);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setRecipe(AltarInfusionRecipe recipe) {
        this.recipe = recipe;
    }

    public AltarInfusionRecipe getRecipe() {
        return this.recipe;
    }

    public void setAltarState(AltarState state) {
        this.altarState = state;
    }

    public AltarState getAltarState() {
        return this.altarState;
    }

    public int getInfusionTimer() {
        return this.infusionTimer;
    }

    public HashMap<String, Integer> getDisplayedIndex() {
        return this.displayedIndex;
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, VaultAltarTileEntity tile) {
        if (world == null || world.f_46443_) {
            return;
        }
        if (tile.altarState == AltarState.IDLE) {
            return;
        }
        if (PlayerVaultAltarData.get((ServerLevel)world).getRecipe(tile.owner) != null && PlayerVaultAltarData.get((ServerLevel)world).getRecipe(tile.owner).isComplete() && tile.altarState != AltarState.INFUSING) {
            tile.altarState = AltarState.COMPLETE;
        }
        switch (tile.altarState) {
            case ACCEPTING: {
                tile.pullNearbyItems(world, PlayerVaultAltarData.get((ServerLevel)world), (double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5, ModConfigs.VAULT_ALTAR.ITEM_RANGE_CHECK);
                break;
            }
            case INFUSING: {
                tile.playInfusionEffects((ServerLevel)world);
                if (tile.infusionTimer-- > 0) break;
                tile.completeInfusion(world);
                tile.sendUpdates();
            }
        }
        tile.recipe = PlayerVaultAltarData.get((ServerLevel)world).getRecipe(tile.owner);
        if (world.m_46467_() % (long)ModConfigs.VAULT_ALTAR.GROUP_DISPLAY_TICKS == 0L) {
            VaultAltarTileEntity.updateDisplayedItems(tile);
        }
        if (world.m_46467_() % 20L == 0L) {
            tile.sendUpdates();
        }
    }

    private static void updateDisplayedItems(VaultAltarTileEntity altar) {
        if (altar.m_58904_() == null) {
            return;
        }
        if (altar.getAltarState() == AltarState.ACCEPTING || altar.getAltarState() == AltarState.INFUSING) {
            AltarInfusionRecipe infusionRecipe = altar.getRecipe();
            if (infusionRecipe == null) {
                return;
            }
            List<RequiredItems> items = infusionRecipe.getRequiredItems();
            for (RequiredItems required : items) {
                String id = required.getPoolId();
                List<ItemStack> stacks = required.getItems();
                int index = altar.displayedIndex.computeIfAbsent(id, poolId -> 0);
                altar.displayedIndex.put(id, index + 1 >= stacks.size() ? 0 : index + 1);
            }
        }
    }

    public void onAltarPowered() {
        ServerLevel serverWorld;
        block3: {
            block2: {
                Level level = this.f_58857_;
                if (!(level instanceof ServerLevel)) break block2;
                serverWorld = (ServerLevel)level;
                if (this.getAltarState() == AltarState.COMPLETE) break block3;
            }
            return;
        }
        PlayerVaultAltarData.get(serverWorld).getAltars(this.owner).forEach(altarPos -> {
            VaultAltarTileEntity altar;
            BlockEntity te;
            if (!this.m_58899_().equals(altarPos) && (te = this.f_58857_.m_7702_(altarPos)) instanceof VaultAltarTileEntity && (altar = (VaultAltarTileEntity)te).getAltarState() != AltarState.IDLE) {
                altar.onRemoveVaultRock();
            }
        });
        serverWorld.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 0.5f);
        this.infusionTimer = ModConfigs.VAULT_ALTAR.INFUSION_TIME * 20;
        this.altarState = AltarState.INFUSING;
    }

    public InteractionResult onAddVaultRock(ServerPlayer player, ItemStack heldItem) {
        if (this.f_58857_ == null) {
            return InteractionResult.FAIL;
        }
        ServerLevel world = (ServerLevel)this.f_58857_;
        List<BlockPos> altarPositions = PlayerVaultAltarData.get(world).getAltars(player.m_142081_());
        for (BlockPos altarPosition : altarPositions) {
            BlockEntity te = world.m_7702_(altarPosition);
            if (!(te instanceof VaultAltarTileEntity)) continue;
            VaultAltarTileEntity altar = (VaultAltarTileEntity)te;
            if (altar.altarState != AltarState.INFUSING) continue;
            return InteractionResult.FAIL;
        }
        PlayerVaultAltarData altarData = PlayerVaultAltarData.get(world);
        this.recipe = altarData.getRecipe(player, this.f_58858_);
        this.setAltarState(AltarState.ACCEPTING);
        if (!player.m_7500_()) {
            heldItem.m_41774_(1);
        }
        this.sendUpdates();
        player.f_8906_.m_141995_((Packet)this.getUpdatePacket());
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onPogRightClick(ServerPlayer player, ItemStack heldItem) {
        if (this.f_58857_ == null) {
            return InteractionResult.FAIL;
        }
        ServerLevel world = (ServerLevel)this.f_58857_;
        if (this.recipe == null) {
            return InteractionResult.SUCCESS;
        }
        List<BlockPos> altarPositions = PlayerVaultAltarData.get(world).getAltars(player.m_142081_());
        for (BlockPos altarPosition : altarPositions) {
            BlockEntity te = world.m_7702_(altarPosition);
            if (!(te instanceof VaultAltarTileEntity)) continue;
            VaultAltarTileEntity altar = (VaultAltarTileEntity)te;
            if (altar.altarState != AltarState.INFUSING) continue;
            return InteractionResult.FAIL;
        }
        ArrayList<RequiredItems> idolRequirements = new ArrayList<RequiredItems>();
        this.recipe.cacheRequiredItems(idolRequirements);
        this.recipe.setPogInfused(true);
        PlayerVaultAltarData.get(world).m_77762_();
        if (!player.m_7500_()) {
            heldItem.m_41774_(1);
        }
        this.sendUpdates();
        world.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 2.0f);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRemoveVaultRock() {
        this.setAltarState(AltarState.IDLE);
        this.recipe = null;
        this.infusionTimer = -666;
        if (this.m_58904_() != null) {
            this.m_58904_().m_7967_((Entity)new ItemEntity(this.m_58904_(), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.5, (double)this.m_58899_().m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.VAULT_ROCK)));
        }
        this.sendUpdates();
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRemovePogInfusion() {
        this.setAltarState(AltarState.ACCEPTING);
        this.recipe.revertCache();
        this.recipe.setPogInfused(false);
        if (this.f_58857_ != null) {
            this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_12556_, SoundSource.BLOCKS, 0.7f, 1.5f);
        }
        this.sendUpdates();
        return InteractionResult.SUCCESS;
    }

    private void completeInfusion(Level world) {
        ServerLevel serverWorld = (ServerLevel)world;
        ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        CrystalData crystal = new CrystalData(stack);
        crystal.setTheme(new PoolCrystalTheme(VaultMod.id("default")));
        int level = PlayerVaultStatsData.get((ServerLevel)world).getVaultStats(this.owner).getVaultLevel();
        crystal.setLevel(level);
        world.m_7967_((Entity)new ItemEntity(world, (double)this.m_58899_().m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, stack));
        PlayerStatsData.get(serverWorld.m_142572_()).onCrystalCrafted(this.owner, this.recipe.getRequiredItems());
        this.resetAltar((ServerLevel)world);
        this.playCompletionEffects(serverWorld);
    }

    private void playInfusionEffects(ServerLevel world) {
        float speed = (float)this.infusionTimer * 0.01f - 0.5f;
        if (speed > 0.0f) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.6, (double)this.m_58899_().m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, (double)speed);
        }
    }

    private void playCompletionEffects(ServerLevel serverWorld) {
        DustParticleOptions particleData = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f);
        for (int i = 0; i < 10; ++i) {
            float offset = 0.1f * (float)i;
            if (serverWorld.f_46441_.nextFloat() < 0.5f) {
                offset *= -1.0f;
            }
            serverWorld.m_8767_((ParticleOptions)particleData, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.6, (double)this.f_58858_.m_123343_() + 0.5, 10, (double)offset, (double)offset, (double)offset, 1.0);
        }
        serverWorld.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 0.7f, 1.5f);
    }

    private void resetAltar(ServerLevel world) {
        this.infusionTimer = -666;
        if (this.recipe.isPogInfused()) {
            this.recipe.revertCache();
            this.recipe.setPogInfused(false);
            PlayerVaultAltarData.get(world).m_77762_();
            this.altarState = AltarState.ACCEPTING;
            this.sendUpdates();
        } else {
            this.recipe = null;
            PlayerVaultAltarData.get(world).removeRecipe(this.owner);
            this.altarState = AltarState.IDLE;
        }
    }

    private void pullNearbyItems(Level world, PlayerVaultAltarData data, double x, double y, double z, double range) {
        if (data.getRecipe(this.owner) == null) {
            return;
        }
        if (data.getRecipe(this.owner).getRequiredItems().isEmpty()) {
            return;
        }
        float speed = ModConfigs.VAULT_ALTAR.PULL_SPEED / 20.0f;
        List entities = world.m_45976_(ItemEntity.class, this.getAABB(range, x, y, z));
        for (ItemEntity itemEntity : entities) {
            if (!this.isItemValid(itemEntity.m_32055_())) continue;
            List<RequiredItems> itemsToPull = data.getRecipe(this.owner).getRequiredItems();
            itemsToPull.stream().filter(requiredItem -> !requiredItem.reachedAmountRequired()).forEach(requiredItem -> {
                if (requiredItem.getItems().stream().noneMatch(itemStack -> ItemStack.m_41758_((ItemStack)itemStack, (ItemStack)itemEntity.m_32055_()))) {
                    return;
                }
                this.moveStacksAndUpdate(data, speed, itemEntity, (RequiredItems)requiredItem);
            });
        }
    }

    public boolean isItemValid(ItemStack stack) {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AltarInfusionRecipe altarInfusionRecipe = PlayerVaultAltarData.get(serverLevel).getRecipe(this.owner);
        if (altarInfusionRecipe == null) {
            return false;
        }
        if (altarInfusionRecipe.isComplete()) {
            return false;
        }
        return altarInfusionRecipe.getRequiredItems().stream().filter(requiredItem -> !requiredItem.reachedAmountRequired()).map(RequiredItems::getItems).flatMap(Collection::stream).anyMatch(requiredStack -> ItemStack.m_41758_((ItemStack)stack, (ItemStack)requiredStack));
    }

    private void moveStacksAndUpdate(PlayerVaultAltarData data, float speed, ItemEntity itemEntity, RequiredItems requiredItems) {
        int excess = requiredItems.getRemainder(itemEntity.m_32055_().m_41613_());
        this.moveItemTowardPedestal(itemEntity, speed);
        if (this.isItemInRange(itemEntity.m_142538_())) {
            if (excess > 0) {
                requiredItems.setCurrentAmount(requiredItems.getAmountRequired());
                itemEntity.m_32055_().m_41764_(excess);
            } else {
                requiredItems.addAmount(itemEntity.m_32055_().m_41613_());
                itemEntity.m_32055_().m_41764_(excess);
                itemEntity.m_146870_();
            }
            data.m_77762_();
            this.sendUpdates();
        }
    }

    private void moveItemTowardPedestal(ItemEntity itemEntity, float speed) {
        Vec3 target = Vec3.m_82512_((Vec3i)this.m_58899_());
        Vec3 current = itemEntity.m_20182_();
        Vec3 velocity = target.m_82546_(current).m_82541_().m_82490_((double)speed);
        itemEntity.m_5997_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
    }

    private boolean isItemInRange(BlockPos itemPos) {
        return itemPos.m_123331_((Vec3i)this.m_58899_()) <= 4.0;
    }

    public AABB getAABB(double range, double x, double y, double z) {
        return new AABB(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.altarState != null) {
            compound.m_128405_("AltarState", this.altarState.ordinal());
        }
        if (this.owner != null) {
            compound.m_128362_("Owner", this.owner);
        }
        if (this.recipe != null) {
            compound.m_128365_("Recipe", (Tag)this.recipe.serializeNBT());
        }
        compound.m_128405_("InfusionTimer", this.infusionTimer);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!compound.m_128441_("AltarState")) {
            this.migrate(compound.m_128471_("containsVaultRock"));
        }
        if (compound.m_128441_("AltarState")) {
            this.altarState = AltarState.values()[compound.m_128451_("AltarState")];
        }
        if (compound.m_128441_("Owner")) {
            this.owner = compound.m_128342_("Owner");
        }
        if (compound.m_128441_("Recipe")) {
            this.recipe = new AltarInfusionRecipe(compound.m_128469_("Recipe"));
        }
        if (compound.m_128441_("InfusionTimer")) {
            this.infusionTimer = compound.m_128451_("InfusionTimer");
        }
    }

    private void migrate(boolean containsVaultRock) {
        this.altarState = containsVaultRock ? AltarState.ACCEPTING : AltarState.IDLE;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        CompoundTag displayed = new CompoundTag();
        this.displayedIndex.forEach((arg_0, arg_1) -> ((CompoundTag)displayed).m_128405_(arg_0, arg_1));
        tag.m_128365_("displayed", (Tag)displayed);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.updateDisplayed(tag);
        super.handleUpdateTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.updateDisplayed(tag);
        }
        super.onDataPacket(net, pkt);
    }

    private void updateDisplayed(CompoundTag tag) {
        CompoundTag displayed = tag.m_128469_("displayed");
        for (String poolId : displayed.m_128431_()) {
            this.displayedIndex.put(poolId, displayed.m_128451_(poolId));
        }
    }

    public static enum AltarState {
        IDLE,
        ACCEPTING,
        COMPLETE,
        INFUSING;

    }
}

