/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.data.PartialTile;
import iskallia.vault.core.world.template.DynamicTemplate;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class TreasureDoorTileEntity
extends BlockEntity {
    private Step step = Step.PLACED;
    private int tunnelSize;
    private ResourceLocation pool;
    private ResourceLocation target;
    private final List<ResourceLocation> palettes = new ArrayList<ResourceLocation>();

    public TreasureDoorTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.TREASURE_DOOR_TILE_ENTITY, pos, state);
    }

    public Step getStep() {
        return this.step;
    }

    public int getTunnelSize() {
        return this.tunnelSize;
    }

    public ResourceLocation getPool() {
        return this.pool;
    }

    public void setStep(Step step) {
        this.step = step;
        this.m_6596_();
    }

    public void setTunnelSize(int tunnelSize) {
        this.tunnelSize = tunnelSize;
        this.m_6596_();
    }

    public void setPool(ResourceLocation pool) {
        this.pool = pool;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("Step", 3)) {
            this.step = Step.values()[nbt.m_128451_("Step")];
        }
        this.tunnelSize = nbt.m_128451_("TunnelSize");
        if (nbt.m_128425_("Pool", 8)) {
            this.pool = new ResourceLocation(nbt.m_128461_("Pool"));
        }
        if (nbt.m_128425_("Target", 8)) {
            this.target = new ResourceLocation(nbt.m_128461_("Target"));
        }
        this.palettes.clear();
        if (nbt.m_128425_("Palettes", 9)) {
            ListTag list = nbt.m_128437_("Palettes", 8);
            for (int i = 0; i < list.size(); ++i) {
                this.palettes.add(new ResourceLocation(list.m_128778_(i)));
            }
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Step", this.step.ordinal());
        nbt.m_128405_("TunnelSize", this.tunnelSize);
        if (this.pool != null) {
            nbt.m_128359_("Pool", this.pool.toString());
        }
        if (this.target != null) {
            nbt.m_128359_("Target", this.target.toString());
        }
        ListTag list = new ListTag();
        this.palettes.forEach(location -> list.add((Object)StringTag.m_129297_((String)location.toString())));
        nbt.m_128365_("Palettes", (Tag)list);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TreasureDoorTileEntity tile) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (!ServerVaults.isVaultWorld(level)) {
            return;
        }
        if (tile.getStep() == Step.PLACED) {
            TreasureDoorTileEntity.fillMissingDoor(world, pos, state);
            if (state.m_61143_((Property)TreasureDoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
                TreasureDoorTileEntity.fillTunnel(world, pos, state, ModBlocks.VAULT_BEDROCK.m_49966_(), tile);
            }
        } else if (tile.getStep() == Step.FILLED && ((Boolean)state.m_61143_((Property)TreasureDoorBlock.f_52727_)).booleanValue() && state.m_61143_((Property)TreasureDoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            TreasureDoorTileEntity.carveTunnel(world, pos, state, Blocks.f_50016_.m_49966_(), tile);
            TreasureDoorTileEntity.generateRoom(world, pos, state, tile);
        }
    }

    public static void fillMissingDoor(ServerLevel world, BlockPos pos, BlockState state) {
        BlockState current = world.m_8055_(pos);
        BlockPos otherPos = pos.m_6630_(current.m_61143_((Property)TreasureDoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? 1 : -1);
        BlockState other = world.m_8055_(otherPos);
        if (other.m_60734_() == ModBlocks.TREASURE_DOOR) {
            return;
        }
        other = (BlockState)current.m_61124_((Property)TreasureDoorBlock.f_52730_, (Comparable)(current.m_61143_((Property)TreasureDoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER));
        world.m_7731_(otherPos, other, 3);
    }

    private static void fillTunnel(ServerLevel world, BlockPos pos, BlockState door, BlockState filler, TreasureDoorTileEntity tile) {
        int offset;
        for (offset = 1; offset <= 48; ++offset) {
            BlockPos pos1 = pos.m_5484_(((Direction)door.m_61143_((Property)TreasureDoorBlock.f_52726_)).m_122424_(), offset);
            Block block1 = world.m_8055_(pos1).m_60734_();
            Block block2 = world.m_8055_(pos1.m_7494_()).m_60734_();
            if (block1.m_155943_() < 0.0f && block2.m_155943_() < 0.0f) break;
            world.m_7731_(pos1.m_7495_(), filler, 3);
            world.m_7731_(pos1, filler, 3);
            world.m_7731_(pos1.m_7494_(), filler, 3);
            world.m_7731_(pos1.m_6630_(2), filler, 3);
            Direction side = ((Direction)door.m_61143_((Property)TreasureDoorBlock.f_52726_)).m_122427_();
            world.m_7731_(pos1.m_142300_(side), filler, 3);
            world.m_7731_(pos1.m_142300_(side).m_7494_(), filler, 3);
            world.m_7731_(pos1.m_142300_(side.m_122424_()), filler, 3);
            world.m_7731_(pos1.m_142300_(side.m_122424_()).m_7494_(), filler, 3);
        }
        tile.setTunnelSize(offset - 1);
        tile.setStep(Step.FILLED);
    }

    private static void carveTunnel(ServerLevel world, BlockPos pos, BlockState door, BlockState carver, TreasureDoorTileEntity tile) {
        for (int offset = 0; offset < tile.tunnelSize; ++offset) {
            BlockPos pos1 = pos.m_5484_(((Direction)door.m_61143_((Property)TreasureDoorBlock.f_52726_)).m_122424_(), offset + 1);
            world.m_7731_(pos1, carver, 3);
            world.m_7731_(pos1.m_7494_(), carver, 3);
        }
    }

    private static void generateRoom(ServerLevel world, BlockPos pos, BlockState state, TreasureDoorTileEntity tile) {
        if (tile.getPool() == null) {
            return;
        }
        TemplatePoolKey key = VaultRegistry.TEMPLATE_POOL.getKey(tile.getPool());
        if (key == null) {
            return;
        }
        Version version = Version.latest();
        ChunkRandom random = ChunkRandom.any();
        Vault vault = ServerVaults.get((Level)world).orElse(null);
        if (vault != null) {
            version = vault.get(Vault.VERSION);
            random.setDecoratorSeed(vault.get(Vault.SEED), pos.m_123341_(), pos.m_123343_(), 329057345);
        }
        PlacementSettings settings = new PlacementSettings().setFlags(3);
        settings.getProcessorContext().random = random;
        settings.getProcessorContext().vault = vault;
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("target", tile.target.toString());
        nbt.m_128359_("pool", tile.pool.toString());
        nbt.m_128359_("final_state", "minecraft:air");
        PartialTile jigsaw = PartialTile.of((BlockState)Blocks.f_50678_.m_49966_().m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)((Direction)state.m_61143_((Property)TreasureDoorBlock.f_52726_)).m_122424_(), (Direction)Direction.UP)), nbt).setPos(pos.m_5484_(((Direction)state.m_61143_((Property)TreasureDoorBlock.f_52726_)).m_122424_(), tile.getTunnelSize()));
        DynamicTemplate root = new DynamicTemplate();
        root.add(jigsaw);
        JigsawTemplate template = JigsawTemplate.of(version, root, tile.palettes.stream().map(location -> VaultRegistry.PALETTE.getKey((ResourceLocation)location)).filter(Objects::nonNull).toList(), 10, random);
        template.place((ServerLevelAccessor)world, settings);
        tile.setStep(Step.GENERATED);
    }

    private static enum Step {
        PLACED,
        FILLED,
        GENERATED;

    }
}

