/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.base.FillableAltarTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.vault.VaultRaid;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.state.BlockState;

public class TimeAltarTileEntity
extends FillableAltarTileEntity {
    public TimeAltarTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.TIME_ALTAR_TILE_ENTITY, pos, state);
    }

    @Override
    public Component getRequirementName() {
        return new TextComponent("Vault Time");
    }

    @Override
    public PlayerFavourData.VaultGodType getAssociatedVaultGod() {
        return PlayerFavourData.VaultGodType.TIMEKEEPER;
    }

    @Override
    public Component getRequirementUnit() {
        return new TextComponent("minutes");
    }

    @Override
    public Color getFillColor() {
        return new Color(-14590);
    }

    @Override
    protected Optional<Integer> calcMaxProgress(VaultRaid vault) {
        return vault.getProperties().getBase(VaultRaid.LEVEL).map(vaultLevel -> {
            float multiplier = vault.getProperties().getBase(VaultRaid.HOST).map(x$0 -> Float.valueOf(this.getMaxProgressMultiplier((UUID)x$0))).orElse(Float.valueOf(1.0f)).floatValue();
            int progress = Math.min(1 + vaultLevel / 20, 3);
            return Math.round((float)progress * multiplier);
        });
    }
}

