/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.config.SpiritConfig;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.PlayerSpiritRecoveryData;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class SpiritExtractorTileEntity
extends BlockEntity
implements IPlayerSkinHolder {
    private static final String OWNER_PROFILE_TAG = "ownerProfile";
    private static final String ITEMS_TAG = "items";
    private static final String PAYMENT_STACK_TAG = "paymentStack";
    private static final String TOTAL_COST_TAG = "totalCost";
    private static final String SPIRIT_RECOVERY_COUNT_TAG = "spiritRecoveryCount";
    @Nullable
    private GameProfile gameProfile;
    private final NonNullList<ItemStack> items = NonNullList.m_122779_();
    private int vaultLevel;
    private ItemStack totalCost = ItemStack.f_41583_;
    private int spiritRecoveryCount = 0;
    private final OverSizedInventory paymentInventory = new OverSizedInventory(1, () -> ((SpiritExtractorTileEntity)this).m_6596_(), player -> true){

        public boolean m_7013_(int pIndex, ItemStack pStack) {
            return SpiritExtractorTileEntity.this.getTotalCost().m_41720_() == pStack.m_41720_();
        }

        @Override
        public int m_6893_() {
            return SpiritExtractorTileEntity.this.getTotalCost().m_41613_();
        }
    };
    private boolean spewingItems;
    private int itemsPerDrop;
    private long spewingCooldownTime;
    private ResourceLocation skinLocation = null;
    private boolean updatingSkin = false;
    private boolean slimSkin = false;

    public SpiritExtractorTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.SPIRIT_EXTRACTOR_TILE_ENTITY, pos, state);
    }

    public ItemStack getTotalCost() {
        if (!this.spewingItems && this.totalCost.m_41619_()) {
            this.recalculateCost();
        }
        return this.totalCost;
    }

    public int getSpiritRecoveryCount() {
        return this.spiritRecoveryCount;
    }

    public void recalculateCost() {
        ServerLevel serverLevel;
        block3: {
            block2: {
                Level level = this.f_58857_;
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (this.gameProfile != null) break block3;
            }
            return;
        }
        this.spiritRecoveryCount = this.getSpiritRecoveryCountFromData(serverLevel);
        this.totalCost = this.spewingItems ? ItemStack.f_41583_ : this.getLevelCost(this.vaultLevel).map(levelCost -> new ItemStack((ItemLike)levelCost.item, this.calculateCount(levelCost.count))).orElse(ItemStack.f_41583_);
    }

    public int getSpiritRecoveryCountFromData(ServerLevel serverLevel) {
        return this.getGameProfile().map(gp -> PlayerSpiritRecoveryData.get(serverLevel).getSpiritRecoveryCount(gp.getId())).orElse(0);
    }

    private int calculateCount(int levelCostCount) {
        return (int)Math.round((double)levelCostCount * Math.pow(ModConfigs.SPIRIT.recoveryCostMultiplier, this.spiritRecoveryCount));
    }

    private Optional<SpiritConfig.LevelCost> getLevelCost(int vaultLevel) {
        SpiritConfig.LevelCost ret = null;
        for (SpiritConfig.LevelCost levelCost : ModConfigs.SPIRIT.levelCosts) {
            if (levelCost.minLevel > vaultLevel || ret != null && ret.minLevel >= levelCost.minLevel) continue;
            ret = levelCost;
        }
        return Optional.ofNullable(ret);
    }

    public OverSizedInventory getPaymentInventory() {
        return this.paymentInventory;
    }

    public void setVaultLevel(int vaultLevel) {
        this.vaultLevel = vaultLevel;
        this.m_6596_();
    }

    @Override
    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
        this.m_6596_();
    }

    @Override
    public Optional<ResourceLocation> getSkinLocation() {
        return Optional.ofNullable(this.skinLocation);
    }

    @Override
    public boolean isUpdatingSkin() {
        return this.updatingSkin;
    }

    @Override
    public void setSkinLocation(ResourceLocation skinLocation) {
        this.skinLocation = skinLocation;
    }

    @Override
    public void startUpdatingSkin() {
        this.updatingSkin = true;
    }

    @Override
    public void stopUpdatingSkin() {
        this.updatingSkin = false;
    }

    @Override
    public boolean hasSlimSkin() {
        return this.slimSkin;
    }

    @Override
    public void setSlimSkin(boolean slimSkin) {
        this.slimSkin = slimSkin;
    }

    @Override
    public Optional<GameProfile> getGameProfile() {
        return Optional.ofNullable(this.gameProfile);
    }

    public void setItems(List<ItemStack> items) {
        this.items.clear();
        this.items.addAll(items);
        this.itemsPerDrop = this.calculateItemsPerDrop();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> this.addSpiritRecoveryData(blockEntity.m_5995_()));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    private CompoundTag addSpiritRecoveryData(CompoundTag tag) {
        tag.m_128365_(TOTAL_COST_TAG, (Tag)this.totalCost.m_41739_(new CompoundTag()));
        tag.m_128405_(SPIRIT_RECOVERY_COUNT_TAG, this.spiritRecoveryCount);
        return tag;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.gameProfile != null) {
            tag.m_128365_(OWNER_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.gameProfile));
        }
        tag.m_128405_("vaultLevel", this.vaultLevel);
        ListTag itemList = new ListTag();
        for (ItemStack item : this.items) {
            itemList.add((Object)item.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(ITEMS_TAG, (Tag)itemList);
        ItemStack goldStack = this.paymentInventory.m_8020_(0);
        if (!goldStack.m_41619_()) {
            tag.m_128365_(PAYMENT_STACK_TAG, (Tag)OverSizedItemStack.of(goldStack).serialize());
        }
        tag.m_128379_("spewingItems", this.spewingItems);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setGameProfile(tag.m_128441_(OWNER_PROFILE_TAG) ? NbtUtils.m_129228_((CompoundTag)tag.m_128469_(OWNER_PROFILE_TAG)) : null);
        if (tag.m_128441_(ITEMS_TAG)) {
            this.items.clear();
            for (Tag itemTag : tag.m_128437_(ITEMS_TAG, 10)) {
                this.items.add((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)itemTag)));
            }
            this.itemsPerDrop = this.calculateItemsPerDrop();
        }
        this.vaultLevel = tag.m_128451_("vaultLevel");
        if (tag.m_128441_(PAYMENT_STACK_TAG)) {
            this.paymentInventory.setOverSizedStack(0, OverSizedItemStack.deserialize(tag.m_128469_(PAYMENT_STACK_TAG)));
        }
        this.spewingItems = tag.m_128471_("spewingItems");
        if (tag.m_128425_(TOTAL_COST_TAG, 10)) {
            this.totalCost = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TOTAL_COST_TAG));
        }
        if (tag.m_128441_(SPIRIT_RECOVERY_COUNT_TAG)) {
            this.spiritRecoveryCount = tag.m_128451_(SPIRIT_RECOVERY_COUNT_TAG);
        }
    }

    private int calculateItemsPerDrop() {
        return this.items.size() <= 20 ? 1 : this.items.size() / 20;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 2.0, 0.0);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void spewItems() {
        if (!this.spewingItems && this.coinsCoverTotalCost()) {
            if (this.f_58857_.m_5776_()) {
                this.spawnParticles();
            } else {
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.gameProfile != null) {
                        PlayerSpiritRecoveryData.get(serverLevel).incrementSpiritRecovery(this.gameProfile.getId());
                    }
                }
                this.paymentInventory.m_6836_(0, ItemStack.f_41583_);
                this.spewingItems = true;
                this.spewingCooldownTime = this.f_58857_.m_46467_() + 20L;
            }
        }
    }

    public boolean coinsCoverTotalCost() {
        int totalCost = this.getTotalCost().m_41613_();
        return totalCost >= 0 && this.paymentInventory.m_8020_(0).m_41613_() >= totalCost;
    }

    private void spawnParticles() {
        int numberOfParticles = 15;
        for (int i = 0; i < numberOfParticles; ++i) {
            double x = (double)this.m_58899_().m_123341_() + this.f_58857_.f_46441_.nextDouble();
            double y = (double)this.m_58899_().m_123342_() + 0.5 + this.f_58857_.f_46441_.nextDouble() * 0.5;
            double z = (double)this.m_58899_().m_123343_() + this.f_58857_.f_46441_.nextDouble();
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, this.f_58857_.f_46441_.nextGaussian() * 0.02, this.f_58857_.f_46441_.nextGaussian() * 0.02, this.f_58857_.f_46441_.nextGaussian() * 0.02);
        }
    }

    public boolean isSpewingItems() {
        return this.spewingItems;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SpiritExtractorTileEntity e) {
        if (!level.m_5776_() && e.spewingItems && e.spewingCooldownTime < level.m_46467_()) {
            if (e.items.isEmpty()) {
                e.spewingItems = false;
                e.spewingCooldownTime = 0L;
                e.removeSpirit();
                return;
            }
            for (int i = 0; i < e.itemsPerDrop; ++i) {
                int itemIndex = level.f_46441_.nextInt(e.items.size());
                Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)(pos.m_123342_() + 1), (double)((double)pos.m_123343_() + 0.5), (ItemStack)((ItemStack)e.items.remove(itemIndex)));
            }
            e.spewingCooldownTime = level.m_46467_() + 2L;
            e.m_6596_();
        }
    }

    public int getVaultLevel() {
        return this.vaultLevel;
    }

    public void removeSpirit() {
        this.gameProfile = null;
        this.itemsPerDrop = 0;
        this.vaultLevel = 0;
        this.paymentInventory.m_6836_(0, ItemStack.f_41583_);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

