/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.SoulAltarBlock;
import iskallia.vault.block.base.FillableAltarBlock;
import iskallia.vault.block.base.FillableAltarTileEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.CodecUtils;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.vault.VaultRaid;
import java.awt.Color;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoulAltarTileEntity
extends FillableAltarTileEntity {
    private static final Random rand = new Random();
    private static final float range = 8.0f;
    private static final AABB SEARCH_BOX = new AABB(-8.0, -8.0, -8.0, 8.0, 8.0, 8.0);
    public static final String SOUL_ALTAR_TAG = "the_vault_SoulAltar";
    public static final String SOUL_ALTAR_REF = "the_vault_SoulAltarPos";
    private int ticksExisted = 0;

    public SoulAltarTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.SOUL_ALTAR_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SoulAltarTileEntity tile) {
        FillableAltarTileEntity.tick(level, pos, state, tile);
        if (!level.m_5776_()) {
            ++tile.ticksExisted;
            if (tile.ticksExisted % 10 != 0) {
                return;
            }
            level.m_6443_(LivingEntity.class, SEARCH_BOX.m_82338_(pos), entity -> entity.m_6084_() && !entity.m_5833_() && !entity.m_20147_() && entity.m_6095_().m_20674_() == MobCategory.MONSTER).forEach(entity -> {
                if (entity.m_20049_(SOUL_ALTAR_TAG)) {
                    CodecUtils.writeNBT(BlockPos.f_121852_, pos, entity.getPersistentData(), SOUL_ALTAR_REF);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level world = entity.m_20193_();
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sWorld = (ServerLevel)world;
        if (!entity.m_19880_().contains(SOUL_ALTAR_TAG)) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        if (!tag.m_128441_(SOUL_ALTAR_REF)) {
            return;
        }
        BlockPos altarRef = CodecUtils.readNBT(BlockPos.f_121852_, tag.m_128423_(SOUL_ALTAR_REF), null);
        if (altarRef == null || !world.m_46805_(altarRef)) {
            return;
        }
        BlockState state = world.m_8055_(altarRef);
        BlockEntity te = world.m_7702_(altarRef);
        if (!(te instanceof SoulAltarTileEntity) || !(state.m_60734_() instanceof SoulAltarBlock)) {
            return;
        }
        ParticleOptions particle = ((SoulAltarBlock)state.m_60734_()).getFlameParticle();
        Vec3 at = MiscUtils.getRandomOffset(entity.m_142469_().m_82400_((double)0.2f), rand);
        sWorld.m_8767_(particle, at.f_82479_, at.f_82480_, at.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @SubscribeEvent
    public static void onEntityDead(LivingDeathEvent event) {
        LivingEntity deadEntity = event.getEntityLiving();
        Level world = deadEntity.m_20193_();
        if (world.m_5776_()) {
            return;
        }
        DamageSource src = event.getSource();
        Entity sourceEntity = src.m_7639_();
        if (sourceEntity instanceof EternalEntity) {
            sourceEntity = ((EternalEntity)sourceEntity).getOwner().right().orElse(null);
        }
        if (!(sourceEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer killer = (ServerPlayer)sourceEntity;
        if (!deadEntity.m_19880_().contains(SOUL_ALTAR_TAG)) {
            return;
        }
        CompoundTag tag = deadEntity.getPersistentData();
        if (!tag.m_128441_(SOUL_ALTAR_REF)) {
            return;
        }
        BlockPos altarRef = CodecUtils.readNBT(BlockPos.f_121852_, tag.m_128423_(SOUL_ALTAR_REF), null);
        if (altarRef == null || !world.m_46805_(altarRef)) {
            return;
        }
        BlockEntity te = world.m_7702_(altarRef);
        if (!(te instanceof SoulAltarTileEntity) || !((SoulAltarTileEntity)te).initialized() || ((SoulAltarTileEntity)te).isMaxedOut()) {
            return;
        }
        ((SoulAltarTileEntity)te).makeProgress(killer, 1, sPlayer -> {
            PlayerFavourData.VaultGodType vg;
            PlayerFavourData data = PlayerFavourData.get(sPlayer.m_183503_());
            if (rand.nextFloat() < FillableAltarBlock.getFavourChance((Player)sPlayer, PlayerFavourData.VaultGodType.MALEVOLENT) && data.addFavour((Player)sPlayer, vg = PlayerFavourData.VaultGodType.MALEVOLENT, 1)) {
                data.addFavour((Player)sPlayer, vg.getOther(rand), -1);
                FillableAltarBlock.playFavourInfo(sPlayer);
            }
        });
        te.m_6596_();
    }

    @Override
    public Component getRequirementName() {
        return new TextComponent("Monster Soul");
    }

    @Override
    public PlayerFavourData.VaultGodType getAssociatedVaultGod() {
        return PlayerFavourData.VaultGodType.MALEVOLENT;
    }

    @Override
    public Component getRequirementUnit() {
        return new TextComponent("kills");
    }

    @Override
    public Color getFillColor() {
        return new Color(-2158319);
    }

    @Override
    protected Optional<Integer> calcMaxProgress(VaultRaid vault) {
        return vault.getProperties().getBase(VaultRaid.LEVEL).map(vaultLevel -> {
            float multiplier = vault.getProperties().getBase(VaultRaid.HOST).map(x$0 -> Float.valueOf(this.getMaxProgressMultiplier((UUID)x$0))).orElse(Float.valueOf(1.0f)).floatValue();
            int progress = 4 + vaultLevel / 7;
            return Math.round((float)progress * multiplier);
        });
    }
}

