/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.config.ShopPedestalConfig;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.gear.VaultLootItem;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ShopPedestalBlockTile
extends BlockEntity {
    private boolean initialized = false;
    private ItemStack offer = ItemStack.f_41583_;
    private ItemStack currency = ItemStack.f_41583_;

    public ShopPedestalBlockTile(BlockPos pos, BlockState state) {
        super(ModBlocks.SHOP_PEDESTAL_TILE_ENTITY, pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 2, 1));
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ShopPedestalBlockTile tile) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (tile.initialized) {
            return;
        }
        tile.initialized = true;
        int level = ServerVaults.getVaultLevelOrZero(serverLevel);
        ShopPedestalConfig.ShopOffer shopOffer = ModConfigs.SHOP_PEDESTAL.getForLevel(level, serverLevel.m_5822_());
        if (shopOffer != null && !shopOffer.isEmpty()) {
            ItemStack offerStack = shopOffer.offer().m_41777_();
            Item item = offerStack.m_41720_();
            if (item instanceof VaultLootItem) {
                VaultLootItem lootItem = (VaultLootItem)item;
                Vault vault = ServerVaults.get((Level)serverLevel).orElse(null);
                if (vault != null) {
                    lootItem.initializeLoot(vault, offerStack);
                }
            }
            offerStack = DataTransferItem.doConvertStack(offerStack);
            tile.offer = offerStack.m_41777_();
            tile.currency = shopOffer.currency().m_41777_();
        }
        tile.m_6596_();
        world.m_7260_(pos, state, state, 3);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.initialized = tag.m_128471_("initialized");
        this.offer = ItemStack.m_41712_((CompoundTag)tag.m_128469_("offerStack"));
        this.currency = ItemStack.m_41712_((CompoundTag)tag.m_128469_("currencyStack"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("initialized", this.initialized);
        tag.m_128365_("offerStack", (Tag)this.offer.serializeNBT());
        tag.m_128365_("currencyStack", (Tag)this.currency.serializeNBT());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public ItemStack getOfferStack() {
        return this.offer.m_41777_();
    }

    public ItemStack getCurrencyStack() {
        return this.currency.m_41777_();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void clear() {
        this.initialized = false;
        this.offer = ItemStack.f_41583_;
        this.currency = ItemStack.f_41583_;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void setOffer(ItemStack offer, ItemStack currency) {
        this.initialized = true;
        this.offer = offer.m_41777_();
        this.currency = currency.m_41777_();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }
}

