/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.network.message.ScavengerAltarConsumeMessage;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class ScavengerAltarTileEntity
extends BlockEntity {
    private static final Random rand = new Random();
    private ItemStack heldItem = ItemStack.f_41583_;
    private UUID itemPlacedBy = null;
    public static final int MAX_CONSUME_TICKS = 40;
    public int ticksToConsume = 40;
    public int ticksToConsumeOld;
    public boolean consuming = false;
    private static final BlockPos[] list = new BlockPos[]{BlockPos.f_121853_.m_142127_(), BlockPos.f_121853_.m_142127_().m_142127_(), BlockPos.f_121853_.m_142127_().m_142126_(), BlockPos.f_121853_.m_142127_().m_142125_(), BlockPos.f_121853_.m_142128_(), BlockPos.f_121853_.m_142128_().m_142128_(), BlockPos.f_121853_.m_142128_().m_142126_(), BlockPos.f_121853_.m_142128_().m_142125_(), BlockPos.f_121853_.m_142125_(), BlockPos.f_121853_.m_142125_().m_142125_(), BlockPos.f_121853_.m_142126_(), BlockPos.f_121853_.m_142126_().m_142126_()};

    protected ScavengerAltarTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public ScavengerAltarTileEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.SCAVENGER_ALTAR_TILE_ENTITY, pos, state);
    }

    public void setItemPlacedBy(UUID itemPlacedBy) {
        this.itemPlacedBy = itemPlacedBy;
    }

    public UUID getItemPlacedBy() {
        return this.itemPlacedBy;
    }

    public void setHeldItem(ItemStack heldItem) {
        this.heldItem = heldItem;
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public static void tickClient(Level world, BlockPos pos, BlockState state, ScavengerAltarTileEntity tile) {
        tile.playEffects(world);
        if (tile.heldItem.m_41619_()) {
            return;
        }
        tile.ticksToConsumeOld = tile.ticksToConsume;
        if (tile.ticksToConsume > 0) {
            --tile.ticksToConsume;
        }
    }

    public static void tickServer(Level world, BlockPos pos, BlockState state, ScavengerAltarTileEntity tile) {
        if (tile.heldItem.m_41619_()) {
            return;
        }
        if (tile.ticksToConsume > 0) {
            if (!tile.consuming) {
                tile.consuming = true;
                world.m_5594_(null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
                tile.m_6596_();
                world.m_7260_(pos, state, state, 3);
            }
            --tile.ticksToConsume;
        } else {
            tile.ticksToConsume = 40;
            tile.consuming = false;
            ItemStack original = tile.heldItem.m_41777_();
            CommonEvents.SCAVENGER_ALTAR_CONSUME.invoke(world, tile);
            if (tile.heldItem.m_41613_() != original.m_41613_()) {
                world.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_5594_(null, pos, SoundEvents.f_12321_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ScavengerAltarConsumeMessage(tile.m_58899_()));
            } else {
                world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
            }
            Block.m_49840_((Level)world, (BlockPos)pos.m_7494_(), (ItemStack)tile.heldItem);
            tile.setHeldItem(ItemStack.f_41583_);
            tile.setItemPlacedBy(null);
        }
        tile.m_6596_();
        world.m_7260_(pos, state, state, 3);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects(Level level) {
        if (!level.f_46443_) {
            return;
        }
        BlockPos pos = this.m_58899_().m_7494_();
        Vec3 vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        int particleSpeed = this.consuming && (float)this.ticksToConsume > 32.0f ? 5 : 40;
        for (BlockPos blockpos : list) {
            float f2;
            float f1;
            float f;
            if (rand.nextInt(particleSpeed) == 0) {
                f = -0.5f + rand.nextFloat() + (float)blockpos.m_123341_();
                f1 = -2.0f + rand.nextFloat() + (float)blockpos.m_123342_();
                f2 = -0.5f + rand.nextFloat() + (float)blockpos.m_123343_();
                level.m_7106_((ParticleOptions)ModParticles.SCAVENGER_CORE.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
            }
            if (rand.nextInt(particleSpeed) == 0) {
                f = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_123341_();
                f1 = -2.0f + rand.nextFloat() + (float)blockpos.m_7494_().m_123342_();
                f2 = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_123343_();
                level.m_7106_((ParticleOptions)ModParticles.SCAVENGER_CORE.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
            }
            if (rand.nextInt(particleSpeed) != 0) continue;
            f = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_123341_();
            f1 = -2.0f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_123342_();
            f2 = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_123343_();
            level.m_7106_((ParticleOptions)ModParticles.SCAVENGER_CORE.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
        }
        if (rand.nextInt(10) == 0) {
            Vec3 rPos = new Vec3((double)pos.m_123341_() + 0.5 + (double)((rand.nextFloat() - rand.nextFloat()) * (rand.nextFloat() * 3.0f) / 10.0f), (double)pos.m_123342_() - 0.25 + (double)((rand.nextFloat() - rand.nextFloat()) * (rand.nextFloat() * 3.0f) / 10.0f), (double)pos.m_123343_() + 0.5 + (double)((rand.nextFloat() - rand.nextFloat()) * (rand.nextFloat() * 3.0f) / 10.0f));
            level.m_7106_((ParticleOptions)ModParticles.SCAVENGER_CORE.get(), rPos.f_82479_, rPos.f_82480_, rPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnConsumeParticles(BlockPos pos) {
        Vec3 offset;
        Random random;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (i = 0; i < 40; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ModParticles.SCAVENGER_CORE_CONSUME.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 0.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 2.0);
        }
        for (i = 0; i < 30; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ModParticles.SCAVENGER_CORE_CONSUME.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2 + 0.2, offset.f_82481_ / 20.0);
        }
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("HeldItem", (Tag)this.getHeldItem().m_41739_(new CompoundTag()));
        if (this.getItemPlacedBy() != null) {
            pTag.m_128362_("ItemPlacedBy", this.getItemPlacedBy());
        }
        pTag.m_128405_("TicksToConsume", this.ticksToConsume);
        pTag.m_128379_("Consuming", this.consuming);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.heldItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("HeldItem"));
        if (pTag.m_128441_("ItemPlacedBy")) {
            this.itemPlacedBy = pTag.m_128342_("ItemPlacedBy");
        }
        this.ticksToConsume = pTag.m_128451_("TicksToConsume");
        this.consuming = pTag.m_128471_("Consuming");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

