/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.SkinProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FinalVaultFrameTileEntity
extends BlockEntity {
    private static final UUID NIL_UUID = new UUID(0L, 0L);
    @Nonnull
    protected UUID ownerUUID = NIL_UUID;
    @Nonnull
    protected String ownerNickname = "";
    protected SkinProfile skin = new SkinProfile();

    public FinalVaultFrameTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.FINAL_VAULT_FRAME_TILE_ENTITY, pos, state);
    }

    @Nonnull
    public String getOwnerNickname() {
        return this.ownerNickname;
    }

    @Nonnull
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public SkinProfile getSkin() {
        return this.skin;
    }

    public void loadFromNBT(CompoundTag nbt) {
        this.ownerUUID = UUID.fromString(nbt.m_128461_("OwnerUUID"));
        this.ownerNickname = nbt.m_128461_("OwnerNickname");
        this.skin.updateSkin(this.ownerNickname);
    }

    public void writeToEntityTag(CompoundTag nbt) {
        nbt.m_128359_("OwnerUUID", this.ownerUUID.toString());
        nbt.m_128359_("OwnerNickname", this.ownerNickname);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.writeToEntityTag(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.loadFromNBT(pTag);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nullable
    public static FinalVaultFrameTileEntity get(BlockGetter reader, BlockPos pos) {
        if (reader == null) {
            return null;
        }
        BlockEntity tileEntity = reader.m_7702_(pos);
        if (tileEntity instanceof FinalVaultFrameTileEntity) {
            FinalVaultFrameTileEntity tileEntity1 = (FinalVaultFrameTileEntity)tileEntity;
            return tileEntity1;
        }
        return null;
    }
}

