/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.CoinStacksGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CoinPilesTileEntity
extends BlockEntity {
    private ResourceLocation lootTable;

    public CoinPilesTileEntity(BlockPos p_155630_, BlockState p_155631_) {
        super(ModBlocks.COIN_PILE_TILE, p_155630_, p_155631_);
    }

    public List<ItemStack> generateLoot(ServerPlayer player) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        CoinStacksGenerationEvent.Data data = CommonEvents.COIN_STACK_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.lootTable, this, loot, Version.latest(), JavaRandom.ofNanoTime(), CoinStacksGenerationEvent.Phase.PRE);
        LootTableKey key = VaultRegistry.LOOT_TABLE.getKey(data.getLootTable());
        if (key != null) {
            LootTableGenerator generator = new LootTableGenerator(Version.latest(), key);
            generator.source = player;
            generator.generate(data.getRandom());
            generator.getItems().forEachRemaining(loot::add);
        }
        CommonEvents.COIN_STACK_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.lootTable, this, loot, data.getVersion(), data.getRandom(), CoinStacksGenerationEvent.Phase.POST);
        return loot;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(nbt.m_128461_("LootTable"));
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.lootTable != null) {
            nbt.m_128359_("LootTable", this.lootTable.toString());
        }
    }
}

