/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.container.inventory.CatalystInfusionTableContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.VaultCatalystInfusedItem;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalystInfusionTableTileEntity
extends BlockEntity
implements MenuProvider {
    public static final String TAG_CATALYST_ITEM_STACK_HANDLER = "catalyst";
    public static final String TAG_INFUSER_ITEM_STACK_HANDLER = "infuser";
    public static final String TAG_OUTPUT_ITEM_STACK_HANDLER = "output";
    public static final String TAG_PROGRESS = "progress";
    private final ItemStackHandler catalystStackHandler = new CatalystInfusionTableStackHandler(this, itemStack -> itemStack.m_41720_() == ModItems.VAULT_CATALYST);
    private final ItemStackHandler infuserStackHandler = new CatalystInfusionTableStackHandler(this, itemStack -> ItemStack.m_150942_((ItemStack)ModConfigs.CATALYST_INFUSION_TABLE.getInfusionItem(), (ItemStack)itemStack));
    private final ItemStackHandler outputStackHandler = new CatalystInfusionTableStackHandler(this, itemStack -> itemStack.m_41720_() == ModItems.VAULT_CATALYST_INFUSED);
    private int progress;

    public CatalystInfusionTableTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.CATALYST_INFUSION_TABLE_TILE_ENTITY, pos, state);
    }

    public void sendUpdates() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        this.m_6596_();
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, CatalystInfusionTableTileEntity tile) {
        boolean active = tile.isActive();
        boolean sendUpdates = false;
        if (active) {
            ++tile.progress;
            tile.playInfusionEffects((ServerLevel)world);
            sendUpdates = true;
        } else if (tile.progress > 0) {
            tile.progress = 0;
            sendUpdates = true;
        }
        if (active && tile.progress >= ModConfigs.CATALYST_INFUSION_TABLE.getInfusionTimeTicks()) {
            tile.catalystStackHandler.getStackInSlot(0).m_41774_(1);
            tile.infuserStackHandler.getStackInSlot(0).m_41774_(1);
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.VAULT_CATALYST_INFUSED);
            VaultCatalystInfusedItem.initializeModifiers(itemStack, world.m_46469_().m_46207_(ModGameRules.CASUAL_VAULTS));
            tile.outputStackHandler.setStackInSlot(0, itemStack);
            tile.progress = 0;
        }
        if (sendUpdates) {
            tile.sendUpdates();
        }
    }

    private void playInfusionEffects(ServerLevel world) {
        float progress = (float)this.progress / (float)ModConfigs.CATALYST_INFUSION_TABLE.getInfusionTimeTicks();
        float speed = progress * 0.05f;
        if (speed > 0.0f) {
            if ((double)progress < 0.5) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.0, (double)this.m_58899_().m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, (double)speed);
            }
            if ((double)progress > 0.75) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123789_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.18, (double)this.m_58899_().m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, (double)speed * 0.2);
            }
            if ((double)progress > 0.95) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123789_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.18, (double)this.m_58899_().m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, (double)speed * 0.3);
            }
        }
    }

    public Stream<ItemStackHandler> getItemStackHandlers() {
        return Stream.of(this.catalystStackHandler, this.infuserStackHandler, this.outputStackHandler);
    }

    public ItemStackHandler getCatalystStackHandler() {
        return this.catalystStackHandler;
    }

    public ItemStackHandler getInfuserStackHandler() {
        return this.infuserStackHandler;
    }

    public ItemStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    public boolean isActive() {
        return !this.catalystStackHandler.getStackInSlot(0).m_41619_() && !this.infuserStackHandler.getStackInSlot(0).m_41619_() && this.outputStackHandler.getStackInSlot(0).m_41619_();
    }

    public float getProgress() {
        return (float)this.progress / (float)ModConfigs.CATALYST_INFUSION_TABLE.getInfusionTimeTicks();
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.catalystStackHandler.deserializeNBT(tag.m_128469_(TAG_CATALYST_ITEM_STACK_HANDLER));
        this.infuserStackHandler.deserializeNBT(tag.m_128469_(TAG_INFUSER_ITEM_STACK_HANDLER));
        this.outputStackHandler.deserializeNBT(tag.m_128469_(TAG_OUTPUT_ITEM_STACK_HANDLER));
        this.progress = tag.m_128451_(TAG_PROGRESS);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(TAG_CATALYST_ITEM_STACK_HANDLER, (Tag)this.catalystStackHandler.serializeNBT());
        tag.m_128365_(TAG_INFUSER_ITEM_STACK_HANDLER, (Tag)this.infuserStackHandler.serializeNBT());
        tag.m_128365_(TAG_OUTPUT_ITEM_STACK_HANDLER, (Tag)this.outputStackHandler.serializeNBT());
        tag.m_128405_(TAG_PROGRESS, this.progress);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @javax.annotation.Nullable Direction side) {
        if (side != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP -> LazyOptional.of(() -> this.catalystStackHandler).cast();
                case Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST -> LazyOptional.of(() -> this.infuserStackHandler).cast();
                case Direction.DOWN -> LazyOptional.of(() -> this.outputStackHandler).cast();
            };
        }
        return super.getCapability(capability, side);
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent("block.the_vault.catalyst_infusion_table");
    }

    @javax.annotation.Nullable
    @ParametersAreNonnullByDefault
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new CatalystInfusionTableContainer(windowId, this.m_58904_(), this.m_58899_(), playerInventory);
    }

    private static class CatalystInfusionTableStackHandler
    extends ItemStackHandler {
        private final CatalystInfusionTableTileEntity tile;
        private final Predicate<ItemStack> itemFilter;

        public CatalystInfusionTableStackHandler(CatalystInfusionTableTileEntity tile, Predicate<ItemStack> itemFilter) {
            this.tile = tile;
            this.itemFilter = itemFilter;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.tile.sendUpdates();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.itemFilter.test(stack);
        }
    }
}

