/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.VaultMod;
import iskallia.vault.container.VaultDiffuserContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.AnimalJarItem;
import iskallia.vault.network.message.AnimalPenParticleMessage;
import iskallia.vault.util.nbt.NBTHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class AnimalPenTileEntity
extends BlockEntity
implements MenuProvider {
    private final AnimalPenInventory inventory = new AnimalPenInventory();
    private ItemStack prevInput = ItemStack.f_41583_;
    private Animal animalToReference = null;
    private Animal dyingAnimalToReference = null;
    private List<Integer> deathTime = new ArrayList<Integer>();
    private int tickCount = 0;
    private static final Method GET_DEATH_SOUND = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_5592_", (Class[])new Class[0]);
    private static final Method GET_EXPERIENCE_REWARD = ObfuscationReflectionHelper.findMethod(Animal.class, (String)"m_6552_", (Class[])new Class[]{Player.class});

    public AnimalPenTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.ANIMAL_PEN_ENTITY, pWorldPosition, pBlockState);
    }

    public Animal getAnimalToReference() {
        return this.animalToReference;
    }

    public Animal getDyingAnimalToReference() {
        return this.dyingAnimalToReference;
    }

    public void playAmbient() {
        if (this.animalToReference != null) {
            Vec3 temp = this.animalToReference.m_20182_();
            this.animalToReference.m_6034_((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() - 0.1f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
            this.animalToReference.m_146867_();
            this.animalToReference.m_8032_();
            this.animalToReference.m_146884_(temp);
            this.animalToReference.m_146867_();
        }
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, AnimalPenTileEntity tile) {
        if (world.m_5776_()) {
            ++tile.tickCount;
            int itor = 0;
            for (int time : tile.deathTime) {
                if (time > 0) {
                    tile.deathTime.set(itor, time + 1);
                    if (time > 25) {
                        tile.deathTime.set(itor, 0);
                        for (int i = 0; i < 10; ++i) {
                            Random random = world.m_5822_();
                            Vec3 offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
                            world.m_6493_((ParticleOptions)ParticleTypes.f_123759_, true, (double)tile.m_58899_().m_123341_() + 0.5 + offset.f_82479_, (double)tile.m_58899_().m_123342_() + random.nextDouble() * (double)0.35f + (double)0.35f, (double)tile.m_58899_().m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.1, offset.f_82481_ / 20.0);
                        }
                    }
                }
                ++itor;
            }
            tile.deathTime.remove((Object)0);
            ItemStack invItem2 = tile.inventory.m_8020_(0);
            ItemStack prevItem = tile.prevInput;
            if (!prevItem.m_41656_(invItem2)) {
                tile.animalToReference = AnimalJarItem.containsEntity(tile.inventory.m_8020_(0)) ? AnimalJarItem.getAnimalFromItemStack(tile.inventory.m_8020_(0), world) : null;
            }
        } else {
            ItemStack invItem;
            tile.animalToReference = tile.animalToReference == null && AnimalJarItem.containsEntity(tile.inventory.m_8020_(0)) ? AnimalJarItem.getAnimalFromItemStack(tile.inventory.m_8020_(0), world) : null;
            Animal invItem2 = tile.animalToReference;
            if (invItem2 instanceof Bee) {
                Bee bee = (Bee)invItem2;
                invItem2 = tile.inventory.m_8020_(0);
                if (invItem2.m_41782_()) {
                    CompoundTag tag = invItem2.m_41784_();
                    if (tag.m_128441_("pollenTimer")) {
                        int timer = tag.m_128451_("pollenTimer");
                        int count = tag.m_128451_("count");
                        boolean honeyReady = false;
                        if (tag.m_128441_("honeyReady") && tag.m_128471_("honeyReady")) {
                            honeyReady = true;
                        }
                        if (timer > 0 && !honeyReady) {
                            tag.m_128405_("pollenTimer", timer - 1);
                            if (timer - 1 == 0) {
                                tag.m_128405_("pollenTimer", Mth.m_14045_((int)((3600 - (count - 1) * 10 * 20) / 5), (int)40, (int)3600));
                                if (tag.m_128441_("honeyLevel")) {
                                    tile.f_58857_.m_5594_(null, tile.m_58899_(), SoundEvents.f_11696_, SoundSource.BLOCKS, 0.75f, 1.0f);
                                    if (tag.m_128451_("honeyLevel") < 5) {
                                        tag.m_128405_("honeyLevel", tag.m_128451_("honeyLevel") + 1);
                                    }
                                    if (tag.m_128451_("honeyLevel") >= 5) {
                                        tag.m_128379_("honeyReady", true);
                                        tile.f_58857_.m_5594_(null, tile.m_58899_(), SoundEvents.f_11694_, SoundSource.BLOCKS, 0.75f, 1.0f);
                                        tile.f_58857_.m_5594_(null, tile.m_58899_(), SoundEvents.f_11698_, SoundSource.BLOCKS, 0.75f, 1.0f);
                                    }
                                }
                            }
                            tile.m_6596_();
                            if (world instanceof ServerLevel) {
                                ServerLevel serverWorld = (ServerLevel)world;
                                serverWorld.m_7260_(tile.m_58899_(), state, state, 3);
                            }
                        }
                    } else {
                        int count = tag.m_128451_("count");
                        tag.m_128405_("honeyLevel", 0);
                        tag.m_128405_("pollenTimer", Mth.m_14045_((int)((3600 - (count - 1) * 10 * 20) / 5), (int)40, (int)3600));
                        tile.m_6596_();
                        if (world instanceof ServerLevel) {
                            ServerLevel serverWorld = (ServerLevel)world;
                            serverWorld.m_7260_(tile.m_58899_(), state, state, 3);
                        }
                    }
                }
            }
            if ((invItem = tile.inventory.m_8020_(0)).m_41782_()) {
                CompoundTag tag = invItem.m_41784_();
                if (tag.m_128441_("shearTimer")) {
                    int timer = tag.m_128451_("shearTimer");
                    if (timer > 1) {
                        tag.m_128405_("shearTimer", timer - 1);
                    } else {
                        tag.m_128473_("shearTimer");
                        tile.playAmbient();
                    }
                    tile.m_6596_();
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.m_7260_(tile.m_58899_(), state, state, 3);
                    }
                }
                if (tag.m_128441_("breedTimer")) {
                    int timer = tag.m_128451_("breedTimer");
                    if (timer > 1) {
                        tag.m_128405_("breedTimer", timer - 1);
                    } else {
                        tag.m_128473_("breedTimer");
                        tile.playAmbient();
                    }
                    tile.m_6596_();
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.m_7260_(tile.m_58899_(), state, state, 3);
                    }
                }
                if (tag.m_128441_("eggTimer")) {
                    int timer = tag.m_128451_("eggTimer");
                    if (timer > 1) {
                        tag.m_128405_("eggTimer", timer - 1);
                    } else {
                        tag.m_128473_("eggTimer");
                        tile.playAmbient();
                    }
                    tile.m_6596_();
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.m_7260_(tile.m_58899_(), state, state, 3);
                    }
                }
            }
        }
        tile.prevInput = tile.inventory.m_8020_(0);
    }

    public List<Integer> getDeathTime() {
        return this.deathTime;
    }

    public boolean attack(@NotNull BlockState state, @NotNull Level level, @NotNull Player player) {
        Animal serverWorld;
        if (!(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SwordItem)) {
            return false;
        }
        if (!AnimalJarItem.containsEntity(this.inventory.m_8020_(0))) {
            return false;
        }
        this.animalToReference = AnimalJarItem.containsEntity(this.inventory.m_8020_(0)) ? AnimalJarItem.getAnimalFromItemStack(this.inventory.m_8020_(0), level) : null;
        if (this.animalToReference == null) {
            return false;
        }
        this.dyingAnimalToReference = this.animalToReference;
        ItemStack invItem = this.getInventory().m_8020_(0);
        if (level.m_5776_()) {
            this.deathTime.add(1);
        } else if (invItem.m_41782_() && invItem.m_41783_().m_128441_("count")) {
            int count = invItem.m_41783_().m_128451_("count") - 1;
            if (count <= 0) {
                this.getInventory().m_6836_(0, ItemStack.f_41583_);
                Block.m_49840_((Level)level, (BlockPos)this.m_58899_(), (ItemStack)new ItemStack((ItemLike)ModItems.ANIMAL_JAR));
            } else {
                invItem.m_41783_().m_128405_("count", count);
            }
            this.m_6596_();
            if (level instanceof ServerLevel) {
                serverWorld = (ServerLevel)level;
                serverWorld.m_7260_(this.m_58899_(), state, state, 3);
            }
        } else {
            return false;
        }
        serverWorld = this.animalToReference;
        if (serverWorld instanceof Sheep) {
            Sheep sheep = (Sheep)serverWorld;
            sheep.m_29878_(invItem.m_41782_() && invItem.m_41783_().m_128441_("shearTimer"));
        }
        DamageSource pDamageSource = DamageSource.m_19344_((Player)player);
        player.m_36346_();
        Vec3 temp = this.animalToReference.m_20182_();
        this.animalToReference.m_6034_((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
        this.animalToReference.m_146867_();
        SoundEvent death = this.getDeathSound((LivingEntity)this.animalToReference);
        level.m_5594_(null, this.m_58899_(), death, SoundSource.BLOCKS, 0.75f, 1.0f);
        level.m_6263_(player, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, SoundEvents.f_12317_, SoundSource.BLOCKS, 0.75f, 1.0f);
        if (!level.m_5776_()) {
            ResourceLocation resourcelocation = this.animalToReference.m_5743_();
            LootTable loottable = level.m_142572_().m_129898_().m_79217_(resourcelocation);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)level).m_78977_(level.f_46441_).m_78972_(LootContextParams.f_81455_, (Object)this.animalToReference).m_78972_(LootContextParams.f_81460_, (Object)this.animalToReference.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)pDamageSource).m_78984_(LootContextParams.f_81458_, (Object)pDamageSource.m_7639_()).m_78984_(LootContextParams.f_81459_, (Object)pDamageSource.m_7640_());
            lootcontext$builder = lootcontext$builder.m_78972_(LootContextParams.f_81456_, (Object)player).m_78963_(player.m_36336_());
            LootContext ctx = lootcontext$builder.m_78975_(LootContextParamSets.f_81415_);
            loottable.m_79129_(ctx).forEach(arg_0 -> ((Animal)this.animalToReference).m_19983_(arg_0));
            int reward = ForgeEventFactory.getExperienceDrop((LivingEntity)this.animalToReference, (Player)player, (int)this.getExperienceReward(this.animalToReference, player));
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)level), (Vec3)this.animalToReference.m_20182_(), (int)reward);
        } else {
            for (int i = 0; i < 5; ++i) {
                Random random = level.m_5822_();
                Vec3 offset = new Vec3(random.nextDouble() / 5.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 5.0 * (double)(random.nextBoolean() ? 1 : -1));
                level.m_6493_((ParticleOptions)ParticleTypes.f_123798_, true, (double)this.m_58899_().m_123341_() + 0.5 + offset.f_82479_, (double)this.m_58899_().m_123342_() + random.nextDouble() * (double)0.35f + (double)0.35f, (double)this.m_58899_().m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1, offset.f_82481_ / 2.0);
            }
        }
        this.animalToReference.m_146884_(temp);
        this.animalToReference.m_146867_();
        return true;
    }

    private SoundEvent getDeathSound(LivingEntity entity) {
        try {
            return (SoundEvent)GET_DEATH_SOUND.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            VaultMod.LOGGER.error("Error calling getDeathSound: ", (Throwable)e);
            return SoundEvents.f_11910_;
        }
    }

    private int getExperienceReward(Animal animal, Player player) {
        try {
            return (Integer)GET_EXPERIENCE_REWARD.invoke((Object)animal, player);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            VaultMod.LOGGER.error("Error calling getExperienceReward: ", (Throwable)e);
            return 0;
        }
    }

    public boolean interact(@NotNull BlockState state, @NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Animal serverWorld;
        Item dyeItem;
        CompoundTag tag;
        Animal serverWorld2;
        ServerLevel serverWorld3;
        BlockItem blockItem;
        Animal shape;
        Item item;
        ItemStack itemInHand = player.m_21120_(hand).m_41777_();
        ItemStack itemInPen = this.inventory.m_8020_(0).m_41777_();
        ItemStack blockInPen = this.inventory.m_8020_(1).m_41777_();
        if (!player.m_6047_() && blockInPen.m_41619_() && (item = itemInHand.m_41720_()) instanceof BlockItem && (shape = (blockItem = (BlockItem)item).m_40614_().m_7947_(blockItem.m_40614_().m_49966_(), (BlockGetter)level, this.m_58899_())) == Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld4 = (ServerLevel)level;
                ItemStack stack = itemInHand.m_41777_();
                stack.m_41764_(1);
                this.inventory.m_6836_(1, stack);
                player.m_21120_(hand).m_41774_(1);
                level.m_5594_(null, this.m_58899_(), blockItem.m_40614_().m_49962_(blockItem.m_40614_().m_49966_()).m_56777_(), SoundSource.BLOCKS, 0.75f, 1.5f);
                this.m_6596_();
                serverWorld4.m_7260_(hit.m_82425_(), state, state, 3);
            }
            return true;
        }
        if (player.m_6047_() && itemInHand.m_41619_() && itemInPen.m_41619_() && !blockInPen.m_41619_()) {
            if (level instanceof ServerLevel) {
                serverWorld3 = (ServerLevel)level;
                player.m_21008_(hand, blockInPen);
                this.inventory.m_8020_(1).m_41774_(1);
                level.m_5594_(null, this.m_58899_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.m_6596_();
                serverWorld3.m_7260_(hit.m_82425_(), state, state, 3);
            }
            return true;
        }
        if (this.animalToReference == null && AnimalJarItem.containsEntity(this.inventory.m_8020_(0))) {
            this.animalToReference = AnimalJarItem.getAnimalFromItemStack(this.inventory.m_8020_(0), level);
        }
        if (!player.m_6047_() && !itemInPen.m_41619_() && itemInHand.m_150930_(Items.f_42446_) && (shape = this.animalToReference) instanceof Cow) {
            Cow cow = (Cow)shape;
            if (level instanceof ServerLevel) {
                serverWorld2 = (ServerLevel)level;
                level.m_5594_(null, this.m_58899_(), SoundEvents.f_11833_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemStack item2 = ItemUtils.m_41813_((ItemStack)player.m_21120_(hand), (Player)player, (ItemStack)Items.f_42455_.m_7968_());
                player.m_21008_(hand, item2);
            }
            return true;
        }
        if (!player.m_6047_() && !itemInPen.m_41619_() && this.animalToReference instanceof Bee && (tag = this.inventory.m_8020_(0).m_41784_()).m_128441_("honeyReady") && tag.m_128471_("honeyReady")) {
            if (itemInHand.m_41720_() instanceof ShearsItem) {
                if (level instanceof ServerLevel) {
                    serverWorld2 = (ServerLevel)level;
                    AnimalPenTileEntity.resetHoney(tag);
                    level.m_5594_(null, this.m_58899_(), SoundEvents.f_11697_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    Block.m_49840_((Level)level, (BlockPos)this.m_58899_(), (ItemStack)new ItemStack((ItemLike)Items.f_42784_, 3));
                    this.m_6596_();
                    serverWorld2.m_7260_(hit.m_82425_(), state, state, 3);
                }
                return true;
            }
            if (itemInHand.m_150930_(Items.f_42590_)) {
                if (level instanceof ServerLevel) {
                    serverWorld2 = (ServerLevel)level;
                    AnimalPenTileEntity.resetHoney(tag);
                    level.m_5594_(null, this.m_58899_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21120_(hand).m_41774_(1);
                    player.m_150109_().m_150079_(new ItemStack((ItemLike)Items.f_42787_, 1));
                    this.m_6596_();
                    serverWorld2.m_7260_(hit.m_82425_(), state, state, 3);
                }
                return true;
            }
        }
        if (!player.m_6047_() && !itemInPen.m_41619_() && this.animalToReference instanceof Chicken && !(tag = this.inventory.m_8020_(0).m_41784_()).m_128441_("eggTimer") && itemInHand.m_150930_(Items.f_42446_)) {
            if (level instanceof ServerLevel) {
                serverWorld2 = (ServerLevel)level;
                level.m_5594_(null, this.m_58899_(), SoundEvents.f_11752_, SoundSource.BLOCKS, 1.0f, 1.0f);
                int count = Mth.m_14045_((int)itemInPen.m_41784_().m_128451_("count"), (int)1, (int)64);
                for (int i = 0; i < count; ++i) {
                    Block.m_49840_((Level)level, (BlockPos)this.m_58899_(), (ItemStack)new ItemStack((ItemLike)Items.f_42521_));
                }
                this.inventory.m_8020_(0).m_41784_().m_128405_("eggTimer", 6000);
                this.m_6596_();
                serverWorld2.m_7260_(hit.m_82425_(), state, state, 3);
            }
            return true;
        }
        if (!player.m_6047_() && !itemInPen.m_41619_() && (serverWorld2 = this.animalToReference) instanceof Sheep) {
            Sheep sheep = (Sheep)serverWorld2;
            Item count = itemInHand.m_41720_();
            if (count instanceof DyeItem) {
                dyeItem = (DyeItem)count;
                if (sheep.m_29874_() != dyeItem.m_41089_()) {
                    if (level instanceof ServerLevel) {
                        serverWorld = (ServerLevel)level;
                        CompoundTag tag2 = this.inventory.m_8020_(0).m_41784_();
                        sheep.m_29855_(dyeItem.m_41089_());
                        sheep.m_20223_(tag2);
                        if (!player.m_7500_()) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        serverWorld.m_5594_(null, this.f_58858_, SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        this.m_6596_();
                        serverWorld.m_7260_(hit.m_82425_(), state, state, 3);
                    } else {
                        sheep.m_29855_(dyeItem.m_41089_());
                    }
                    return true;
                }
            }
        }
        if (!player.m_6047_() && !itemInPen.m_41619_() && (dyeItem = itemInHand.m_41720_()) instanceof ShearsItem) {
            ShearsItem shearsItem = (ShearsItem)dyeItem;
            if (this.animalToReference == null && AnimalJarItem.containsEntity(this.inventory.m_8020_(0))) {
                this.animalToReference = AnimalJarItem.getAnimalFromItemStack(this.inventory.m_8020_(0), level);
            }
            if (this.animalToReference == null) {
                return false;
            }
            serverWorld = this.animalToReference;
            if (serverWorld instanceof Sheep) {
                Sheep sheep = (Sheep)serverWorld;
                if (this.inventory.m_8020_(0).m_41784_().m_128441_("shearTimer")) {
                    return false;
                }
                if (level instanceof ServerLevel) {
                    serverWorld = (ServerLevel)level;
                    Vec3 temp = this.animalToReference.m_20182_();
                    this.animalToReference.m_6034_((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() - 0.1f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
                    this.animalToReference.m_146867_();
                    int count = 1;
                    if (this.inventory.m_8020_(0).m_41784_().m_128441_("count")) {
                        count = this.inventory.m_8020_(0).m_41784_().m_128451_("count");
                    }
                    if (count < 75) {
                        for (int i = 0; i < count; ++i) {
                            int spawnCount = 1 + level.f_46441_.nextInt(3);
                            for (int j = 0; j < spawnCount; ++j) {
                                ItemEntity itementity = this.animalToReference.m_20000_((ItemLike)Sheep.f_29800_.get(sheep.m_29874_()), 1);
                                if (itementity == null) continue;
                                itementity.m_20256_(itementity.m_20184_().m_82520_((double)((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.1f), (double)(level.f_46441_.nextFloat() * 0.05f), (double)((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.1f)));
                            }
                        }
                    } else {
                        int spawnCount = 0;
                        for (int i = 0; i < count; ++i) {
                            spawnCount += 1 + level.f_46441_.nextInt(3);
                        }
                        while (spawnCount > 0) {
                            if (spawnCount >= 64) {
                                spawnCount -= 64;
                                ItemEntity itementity = this.animalToReference.m_5552_(new ItemStack((ItemLike)Sheep.f_29800_.get(sheep.m_29874_()), 64), 1.0f);
                                if (itementity == null) continue;
                                itementity.m_20256_(itementity.m_20184_().m_82520_((double)((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.1f), (double)(level.f_46441_.nextFloat() * 0.05f), (double)((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.1f)));
                                continue;
                            }
                            ItemEntity itementity = this.animalToReference.m_5552_(new ItemStack((ItemLike)Sheep.f_29800_.get(sheep.m_29874_()), spawnCount), 1.0f);
                            if (itementity != null) {
                                itementity.m_20256_(itementity.m_20184_().m_82520_((double)((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.1f), (double)(level.f_46441_.nextFloat() * 0.05f), (double)((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.1f)));
                            }
                            spawnCount = 0;
                        }
                    }
                    sheep.m_5851_(SoundSource.BLOCKS);
                    level.m_5594_((Player)null, this.m_58899_(), SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.animalToReference.m_146884_(temp);
                    this.animalToReference.m_146867_();
                    this.inventory.m_8020_(0).m_41784_().m_128405_("shearTimer", 6000);
                    this.m_6596_();
                    serverWorld.m_7260_(hit.m_82425_(), state, state, 3);
                }
                return true;
            }
        }
        if (!player.m_6047_() && !itemInPen.m_41619_() && itemInHand.m_41720_() instanceof AnimalJarItem && itemInHand.m_41784_().m_128441_("entity") && itemInPen.m_41784_().m_128441_("entity") && itemInHand.m_41784_().m_128461_("entity").equals(itemInPen.m_41784_().m_128461_("entity"))) {
            if (level instanceof ServerLevel) {
                serverWorld3 = (ServerLevel)level;
                CompoundTag tag3 = this.inventory.m_8020_(0).m_41784_();
                tag3.m_128405_("count", tag3.m_128451_("count") + itemInHand.m_41784_().m_128451_("count"));
                player.m_21008_(hand, new ItemStack((ItemLike)ModItems.ANIMAL_JAR));
                this.m_6596_();
                serverWorld3.m_7260_(hit.m_82425_(), state, state, 3);
                level.m_5594_((Player)null, this.m_58899_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (!player.m_6047_() && itemInPen.m_41619_() && itemInHand.m_41720_() instanceof AnimalJarItem && itemInHand.m_41782_() && itemInHand.m_41784_().m_128441_("entity") || player.m_6047_() && itemInHand.m_41619_()) {
            if (level instanceof ServerLevel) {
                serverWorld3 = (ServerLevel)level;
                this.inventory.m_6836_(0, itemInHand);
                player.m_21008_(hand, itemInPen);
                this.animalToReference = AnimalJarItem.containsEntity(this.inventory.m_8020_(0)) ? AnimalJarItem.getAnimalFromItemStack(this.inventory.m_8020_(0), level) : null;
                if (this.animalToReference != null) {
                    level.m_5594_(null, this.m_58899_(), SoundEvents.f_12015_, SoundSource.BLOCKS, 0.75f, 1.0f);
                    Vec3 temp = this.animalToReference.m_20182_();
                    this.animalToReference.m_6034_((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.1f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
                    this.animalToReference.m_146867_();
                    this.animalToReference.m_8032_();
                    this.animalToReference.m_146884_(temp);
                    this.animalToReference.m_146867_();
                } else {
                    level.m_5594_(null, this.m_58899_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 0.75f, 1.0f);
                }
                this.m_6596_();
                serverWorld3.m_7260_(hit.m_82425_(), state, state, 3);
            }
            return true;
        }
        if (this.animalToReference == null && AnimalJarItem.containsEntity(this.inventory.m_8020_(0))) {
            this.animalToReference = AnimalJarItem.getAnimalFromItemStack(this.inventory.m_8020_(0), level);
        }
        if (this.animalToReference == null) {
            return false;
        }
        if (this.inventory.m_8020_(0).m_41784_().m_128441_("breedTimer")) {
            return false;
        }
        if (this.animalToReference.m_6898_(itemInHand) && this.inventory.m_8020_(0).m_41784_().m_128441_("count")) {
            int count = this.inventory.m_8020_(0).m_41784_().m_128451_("count");
            int stackCount = itemInHand.m_41613_();
            int usedCount = 0;
            usedCount = stackCount > count ? count : stackCount;
            if (itemInHand.m_41613_() == 1) {
                usedCount = 1;
            }
            if (count > 1) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld5 = (ServerLevel)level;
                    level.m_5594_(null, this.m_58899_(), this.animalToReference.m_7866_(itemInHand), SoundSource.BLOCKS, 0.75f, 1.0f);
                    Vec3 temp = this.animalToReference.m_20182_();
                    this.animalToReference.m_6034_((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.1f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
                    this.animalToReference.m_146867_();
                    this.animalToReference.m_8032_();
                    this.animalToReference.m_146884_(temp);
                    this.animalToReference.m_146867_();
                    player.m_21120_(hand).m_41774_(usedCount);
                    CompoundTag tag4 = this.inventory.m_8020_(0).m_41784_();
                    tag4.m_128405_("breedTimer", 1100 + 100 * (usedCount / 2));
                    tag4.m_128405_("count", tag4.m_128451_("count") + usedCount / 2);
                    ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new AnimalPenParticleMessage(this.m_58899_()));
                }
                return true;
            }
            player.m_5661_((Component)new TextComponent("Needs at least two to breed.."), true);
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (int i = 0; i < 7; ++i) {
            Random random = level.m_5822_();
            Vec3 offset = new Vec3(random.nextDouble() / 5.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 5.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ParticleTypes.f_123750_, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.35f + (double)0.35f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1, offset.f_82481_ / 2.0);
        }
    }

    public static void resetHoney(CompoundTag tag) {
        tag.m_128379_("honeyReady", false);
        tag.m_128405_("honeyLevel", 0);
        tag.m_128405_("pollenTimer", Mth.m_14045_((int)((3600 - (tag.m_128451_("count") - 1) * 10 * 20) / 5), (int)40, (int)3600));
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public AnimalPenInventory getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        NBTHelper.deserializeSimpleContainer(this.inventory, tag.m_128437_("inventory", 10));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)NBTHelper.serializeSimpleContainer(this.inventory));
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultDiffuserContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public class AnimalPenInventory
    extends SimpleContainer {
        public AnimalPenInventory() {
            super(2);
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return true;
        }

        public void m_6596_() {
            super.m_6596_();
            AnimalPenTileEntity.this.m_6596_();
        }
    }
}

