/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.google.common.collect.Iterables;
import iskallia.vault.block.entity.CryoChamberTileEntity;
import iskallia.vault.client.ClientEternalData;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.EternalsData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AncientCryoChamberTileEntity
extends CryoChamberTileEntity {
    public AncientCryoChamberTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ANCIENT_CRYO_CHAMBER_TILE_ENTITY, pos, state);
        this.setMaxCores(1);
    }

    public void setEternalName(String coreName) {
        this.coreNames.clear();
        this.coreNames.add(coreName);
        this.m_6596_();
    }

    @Nonnull
    public String getEternalName() {
        return (String)Iterables.getFirst((Iterable)this.coreNames, (Object)"Unknown");
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AncientCryoChamberTileEntity tile) {
        if (level == null || level.f_46443_ || tile.getOwner() == null) {
            return;
        }
        if (tile.getEternalId() != null && level.m_46467_() % 40L == 0L) {
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11768_, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
        if (tile.getEternalId() == null && !tile.coreNames.isEmpty()) {
            tile.createAncient();
            tile.sendUpdates();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateSkin() {
        if (this.eternalId == null && !this.coreNames.isEmpty()) {
            this.skin.updateSkin(this.getEternalName());
            return;
        }
        EternalDataSnapshot snapshot = ClientEternalData.getSnapshot(this.getEternalId());
        if (snapshot == null || snapshot.getName() == null) {
            return;
        }
        this.skin.updateSkin(snapshot.getName());
    }

    private void createAncient() {
        EternalsData.EternalVariant variant;
        String name = (String)Iterables.getFirst((Iterable)this.coreNames, (Object)"Unknown");
        this.variant = variant = EternalsData.EternalVariant.byId(new Random().nextInt(EternalsData.EternalVariant.values().length));
        this.eternalId = EternalsData.get((ServerLevel)this.m_58904_()).add(this.getOwner(), name, true, variant, false);
    }
}

