/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.base;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.LootableBlockGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class LootableTileEntity
extends BlockEntity {
    private ResourceLocation lootTable;

    public LootableTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public List<ItemStack> generateLoot(ServerPlayer player) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        LootableBlockGenerationEvent.Data data = CommonEvents.LOOTABLE_BLOCK_GENERATION_EVENT.invoke(player, this.m_58900_(), this.m_58899_(), this.lootTable, this, loot, Version.latest(), JavaRandom.ofNanoTime(), LootableBlockGenerationEvent.Phase.PRE);
        LootTableKey key = VaultRegistry.LOOT_TABLE.getKey(data.getLootTable());
        if (key != null) {
            LootTableGenerator generator = new LootTableGenerator(Version.latest(), key);
            generator.source = player;
            generator.generate(data.getRandom());
            generator.getItems().forEachRemaining(loot::add);
        }
        CommonEvents.LOOTABLE_BLOCK_GENERATION_EVENT.invoke(player, this.m_58900_(), this.m_58899_(), this.lootTable, this, loot, data.getVersion(), data.getRandom(), LootableBlockGenerationEvent.Phase.POST);
        return loot;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(nbt.m_128461_("LootTable"));
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.lootTable != null) {
            nbt.m_128359_("LootTable", this.lootTable.toString());
        }
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }
}

