/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.base;

import iskallia.vault.block.base.LootableTileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;

public abstract class LootableBlock
extends Block
implements EntityBlock {
    public LootableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level.m_5776_()) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof LootableTileEntity)) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        LootableTileEntity te = (LootableTileEntity)blockEntity;
        if (te.getLootTable() == null) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        this.m_5707_(level, pos, state, player);
        List<ItemStack> loot = this.generateLoot(te, player);
        this.dropLoot(level, pos, loot);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        return false;
    }

    protected void dropLoot(Level level, BlockPos pos, List<ItemStack> loot) {
        loot.forEach(stack -> LootableBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
    }

    protected List<ItemStack> generateLoot(LootableTileEntity te, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return List.of();
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        return te.generateLoot(serverPlayer);
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }
}

