/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.base;

import com.mojang.brigadier.StringReader;
import iskallia.vault.core.world.data.PartialTile;
import iskallia.vault.core.world.data.TileParser;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.vault.VaultRaid;
import java.awt.Color;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FillableAltarTileEntity
extends BlockEntity {
    protected static final Random rand = new Random();
    private int currentProgress = 0;
    protected int maxProgress = 0;
    protected PartialTile replacement = PartialTile.of(Blocks.f_50016_);

    public FillableAltarTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public boolean initialized() {
        return this.getMaxProgress() > 0;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public boolean isMaxedOut() {
        return this.currentProgress >= this.getMaxProgress();
    }

    public float progressPercentage() {
        return Math.min((float)this.getCurrentProgress() / (float)this.getMaxProgress(), 1.0f);
    }

    public void makeProgress(ServerPlayer sPlayer, int deltaProgress, Consumer<ServerPlayer> onComplete) {
        if (!this.initialized()) {
            return;
        }
        this.currentProgress += deltaProgress;
        this.sendUpdates();
        if (this.isMaxedOut()) {
            onComplete.accept(sPlayer);
        }
    }

    public static <A extends FillableAltarTileEntity> void tick(Level level, BlockPos pos, BlockState state, A tile) {
        if (tile.initialized()) {
            return;
        }
    }

    protected float getMaxProgressMultiplier(UUID playerUUID) {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)level;
            int favour = PlayerFavourData.get(sWorld).getFavour(playerUUID, this.getAssociatedVaultGod());
            if (favour < 0) {
                return 1.0f + 0.2f * ((float)Math.abs(favour) / 6.0f);
            }
            return 1.0f - 0.75f * (Math.min((float)favour, 8.0f) / 8.0f);
        }
        return 1.0f;
    }

    public abstract Component getRequirementName();

    public abstract PlayerFavourData.VaultGodType getAssociatedVaultGod();

    public abstract Component getRequirementUnit();

    public abstract Color getFillColor();

    protected abstract Optional<Integer> calcMaxProgress(VaultRaid var1);

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("CurrentProgress", this.currentProgress);
        nbt.m_128405_("MaxProgress", this.maxProgress);
        nbt.m_128359_("Replacement", this.replacement.toString());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.currentProgress = nbt.m_128451_("CurrentProgress");
        int n = this.maxProgress = nbt.m_128441_("MaxProgress") ? nbt.m_128451_("MaxProgress") : -1;
        if (nbt.m_128441_("Replacement")) {
            this.replacement = new TileParser(new StringReader(nbt.m_128461_("Replacement")), ModBlocks.ERROR_BLOCK, true).toTile();
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.m_6596_();
        }
    }

    public void placeReplacement(Level world, BlockPos pos) {
        BlockEntity blockEntity;
        PartialTile tile = PartialTile.at(world, pos);
        this.replacement.copyInto(tile);
        world.m_7731_(pos, tile.getState().asBlockState(), 3);
        if (tile.getNbt() != null && (blockEntity = world.m_7702_(pos)) != null) {
            blockEntity.m_142466_((CompoundTag)tile.getNbt());
        }
    }
}

