/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.base;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.base.FillableAltarTileEntity;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.gear.IdolItem;
import iskallia.vault.world.data.PlayerFavourData;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class FillableAltarBlock<T extends FillableAltarTileEntity>
extends FacedBlock
implements EntityBlock {
    protected static final Random rand = new Random();
    public static final float FAVOUR_CHANCE = 0.05f;
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);

    public FillableAltarBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 3600000.0f).m_60993_().m_60955_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public abstract ParticleOptions getFlameParticle();

    public abstract PlayerFavourData.VaultGodType getAssociatedVaultGod();

    public abstract ItemStack getAssociatedVaultGodShard();

    public abstract InteractionResult rightClicked(BlockState var1, ServerLevel var2, BlockPos var3, T var4, ServerPlayer var5, ItemStack var6);

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        ItemStack heldStack = player.m_21120_(hand);
        if (tileEntity != null) {
            try {
                if (((FillableAltarTileEntity)tileEntity).isMaxedOut()) {
                    ((FillableAltarTileEntity)tileEntity).placeReplacement(world, pos);
                    return InteractionResult.SUCCESS;
                }
                return this.rightClicked(state, (ServerLevel)world, pos, (FillableAltarTileEntity)tileEntity, (ServerPlayer)player, heldStack);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return InteractionResult.FAIL;
    }

    public static float getFavourChance(Player player, PlayerFavourData.VaultGodType favourType) {
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        if (offHand.m_41619_() || !(offHand.m_41720_() instanceof IdolItem)) {
            return 0.05f;
        }
        if (favourType != ((IdolItem)offHand.m_41720_()).getType()) {
            return 0.05f;
        }
        int multiplier = 2;
        return 0.05f * (float)multiplier;
    }

    public static void playFavourInfo(ServerPlayer sPlayer) {
        BlockPos pos = sPlayer.m_142538_();
        sPlayer.f_19853_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSounds.FAVOUR_UP, SoundSource.PLAYERS, 0.4f, 0.7f);
        MutableComponent msg = new TextComponent("You gained a favour!").m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.BOLD);
        sPlayer.m_5661_((Component)msg, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level world, BlockPos pos, Random rand) {
        this.addFlameParticle(world, pos, 1.0, 17.0, 15.0);
        this.addFlameParticle(world, pos, 15.0, 17.0, 15.0);
        this.addFlameParticle(world, pos, 15.0, 17.0, 1.0);
        this.addFlameParticle(world, pos, 1.0, 17.0, 1.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFlameParticle(Level world, BlockPos pos, double xOffset, double yOffset, double zOffset) {
        double x = (double)pos.m_123341_() + xOffset / 16.0;
        double y = (double)pos.m_123342_() + yOffset / 16.0;
        double z = (double)pos.m_123343_() + zOffset / 16.0;
        world.m_7106_(this.getFlameParticle(), x, y, z, 0.0, 0.0, 0.0);
    }
}

