/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FillableAltarBlock;
import iskallia.vault.block.entity.XpAltarTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModParticles;
import iskallia.vault.world.data.PlayerFavourData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class XPAltarBlock
extends FillableAltarBlock<XpAltarTileEntity> {
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.XP_ALTAR_TILE_ENTITY.m_155264_(pPos, pState);
    }

    @Override
    public ParticleOptions getFlameParticle() {
        return (ParticleOptions)ModParticles.BLUE_FLAME.get();
    }

    @Override
    public PlayerFavourData.VaultGodType getAssociatedVaultGod() {
        return PlayerFavourData.VaultGodType.OMNISCIENT;
    }

    @Override
    public ItemStack getAssociatedVaultGodShard() {
        return new ItemStack((ItemLike)ModItems.CRYSTAL_SHARD_OMNISCIENT);
    }

    @Override
    public InteractionResult rightClicked(BlockState state, ServerLevel world, BlockPos pos, XpAltarTileEntity tileEntity, ServerPlayer player, ItemStack heldStack) {
        if (!tileEntity.initialized()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_7500_()) {
            tileEntity.makeProgress(player, tileEntity.getMaxProgress() - tileEntity.getCurrentProgress(), sPlayer -> {});
            return InteractionResult.SUCCESS;
        }
        if (player.f_36078_ <= 0) {
            return InteractionResult.FAIL;
        }
        int levelDrain = Math.min(player.f_36078_, tileEntity.getMaxProgress() - tileEntity.getCurrentProgress());
        player.m_9174_(player.f_36078_ - levelDrain);
        tileEntity.makeProgress(player, levelDrain, sPlayer -> {
            PlayerFavourData.VaultGodType vg;
            PlayerFavourData data = PlayerFavourData.get(sPlayer.m_183503_());
            if (rand.nextFloat() < XPAltarBlock.getFavourChance((Player)sPlayer, PlayerFavourData.VaultGodType.OMNISCIENT) && data.addFavour((Player)sPlayer, vg = this.getAssociatedVaultGod(), 1)) {
                data.addFavour((Player)sPlayer, vg.getOther(rand), -1);
                FillableAltarBlock.playFavourInfo(sPlayer);
            }
        });
        return InteractionResult.SUCCESS;
    }
}

