/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.google.common.collect.Lists;
import iskallia.vault.block.entity.VaultRaidControllerTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.VoxelUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VaultRaidControllerBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape SHAPE_TOP = VaultRaidControllerBlock.makeShape().m_83216_(0.0, -1.0, 0.0);
    private static final VoxelShape SHAPE_BOTTOM = VaultRaidControllerBlock.makeShape();

    public VaultRaidControllerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60918_(SoundType.f_56744_).m_60913_(-1.0f, 3600000.0f).m_60910_().m_60955_().m_60993_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level p_153212_, BlockState state, BlockEntityType<A> tBlockEntityType) {
        return BlockHelper.getTicker(tBlockEntityType, ModBlocks.RAID_CONTROLLER_TILE_ENTITY, VaultRaidControllerTileEntity::tick);
    }

    private static VoxelShape makeShape() {
        VoxelShape m1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape m2 = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)29.0, (double)14.0);
        return VoxelUtils.combineAll(BooleanOp.f_82695_, m1, m2);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_TOP;
        }
        return SHAPE_BOTTOM;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState downState = world.m_8055_(pos.m_7495_());
            if (!(downState.m_60734_() instanceof VaultRaidControllerBlock)) {
                return InteractionResult.SUCCESS;
            }
            return this.m_6227_(downState, world, pos.m_7495_(), player, hand, hit);
        }
        if (!world.m_5776_() && world instanceof ServerLevel && hand == InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        if (!state.m_60713_(newState.m_60734_())) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                BlockState otherState = world.m_8055_(pos.m_7495_());
                if (otherState.m_60713_(state.m_60734_())) {
                    world.m_7471_(pos.m_7495_(), isMoving);
                }
            } else {
                BlockState otherState = world.m_8055_(pos.m_7494_());
                if (otherState.m_60713_(state.m_60734_())) {
                    world.m_7471_(pos.m_7494_(), isMoving);
                }
            }
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return Lists.newArrayList();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return ModBlocks.RAID_CONTROLLER_TILE_ENTITY.m_155264_(pPos, pState);
        }
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF});
    }
}

