/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.VaultPortalBlock;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class VaultPortalSize {
    private final LevelAccessor world;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private int portalBlockCount;
    @Nullable
    private BlockPos bottomLeft;
    private int height;
    private final int width;
    private final BlockBehaviour.StatePredicate positionPredicate;

    public VaultPortalSize(LevelAccessor worldIn, BlockPos pos, Direction.Axis axisIn, BlockBehaviour.StatePredicate positionPredicate) {
        this.world = worldIn;
        this.axis = axisIn;
        this.rightDir = axisIn == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.positionPredicate = positionPredicate;
        this.bottomLeft = this.computeBottomLeft(pos);
        if (this.bottomLeft == null) {
            this.bottomLeft = pos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.computeWidth();
            if (this.width > 0) {
                this.height = this.computeHeight();
            }
        }
    }

    public static Optional<VaultPortalSize> getPortalSize(LevelAccessor world, BlockPos pos, Direction.Axis axis, BlockBehaviour.StatePredicate positionPredicate) {
        return VaultPortalSize.getPortalSize(world, pos, size -> size.isValid() && size.portalBlockCount == 0, axis, positionPredicate);
    }

    public static Optional<VaultPortalSize> getPortalSize(LevelAccessor world, BlockPos pos, Predicate<VaultPortalSize> sizePredicate, Direction.Axis axis, BlockBehaviour.StatePredicate positionPredicate) {
        Optional<VaultPortalSize> optional = Optional.of(new VaultPortalSize(world, pos, axis, positionPredicate)).filter(sizePredicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new VaultPortalSize(world, pos, direction$axis, positionPredicate)).filter(sizePredicate);
    }

    public static List<BlockPos> getFrame(LevelAccessor world, BlockPos pos) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        Optional<VaultPortalSize> portalSize = VaultPortalSize.findPortalSizeFromPortalBlock(world, pos);
        if (portalSize.isPresent()) {
            BlockPos current;
            VaultPortalSize size = portalSize.get();
            BlockPos blockPos = current = size.bottomLeft == null ? null : size.bottomLeft.m_142300_(size.rightDir.m_122424_()).m_7495_();
            if (current != null) {
                positions.add(current);
                VaultPortalSize.findAndAddPositions(world, positions, size, current);
            }
        }
        return positions;
    }

    private static void findAndAddPositions(LevelAccessor world, List<BlockPos> positions, VaultPortalSize size, BlockPos current) {
        for (int up = 0; up <= size.height; ++up) {
            if (!VaultPortalBlock.FRAME.m_61035_(world.m_8055_(current.m_7494_()), (BlockGetter)world, current.m_7494_())) {
                current = current.m_7494_();
                positions.add(current);
                break;
            }
            current = current.m_7494_();
            positions.add(current);
        }
        for (int right = 0; right <= size.width; ++right) {
            if (!VaultPortalBlock.FRAME.m_61035_(world.m_8055_(current.m_142300_(size.rightDir)), (BlockGetter)world, current.m_142300_(size.rightDir))) {
                current = current.m_142300_(size.rightDir);
                positions.add(current);
                break;
            }
            current = current.m_142300_(size.rightDir);
            positions.add(current);
        }
        for (int down = 0; down <= size.height; ++down) {
            if (!VaultPortalBlock.FRAME.m_61035_(world.m_8055_(current.m_7495_()), (BlockGetter)world, current.m_7495_())) {
                current = current.m_7495_();
                positions.add(current);
                break;
            }
            current = current.m_7495_();
            positions.add(current);
        }
        for (int left = 0; left < size.width; ++left) {
            if (!VaultPortalBlock.FRAME.m_61035_(world.m_8055_(current.m_142300_(size.rightDir.m_122424_())), (BlockGetter)world, current.m_142300_(size.rightDir.m_122424_()))) {
                positions.add(current.m_7494_());
                break;
            }
            current = current.m_142300_(size.rightDir.m_122424_());
            positions.add(current);
        }
    }

    private static Optional<VaultPortalSize> findPortalSizeFromPortalBlock(LevelAccessor world, BlockPos pos) {
        Optional<VaultPortalSize> portalSize = VaultPortalSize.getPortalSize(world, pos.m_142127_(), VaultPortalSize::isValid, Direction.Axis.Z, VaultPortalBlock.FRAME);
        if (!portalSize.isPresent()) {
            portalSize = VaultPortalSize.getPortalSize(world, pos.m_142128_(), VaultPortalSize::isValid, Direction.Axis.Z, VaultPortalBlock.FRAME);
        }
        if (!portalSize.isPresent()) {
            portalSize = VaultPortalSize.getPortalSize(world, pos.m_142126_(), VaultPortalSize::isValid, Direction.Axis.X, VaultPortalBlock.FRAME);
        }
        if (!portalSize.isPresent()) {
            portalSize = VaultPortalSize.getPortalSize(world, pos.m_142125_(), VaultPortalSize::isValid, Direction.Axis.X, VaultPortalBlock.FRAME);
        }
        return portalSize;
    }

    private static boolean canConnect(BlockState state) {
        return state.m_60795_() || state.m_60713_((Block)ModBlocks.VAULT_PORTAL) || state.m_60713_((Block)ModBlocks.OTHER_SIDE_PORTAL);
    }

    @Nullable
    private BlockPos computeBottomLeft(BlockPos pos) {
        int i = Math.max(0, pos.m_123342_() - 21);
        while (pos.m_123342_() > i && VaultPortalSize.canConnect(this.world.m_8055_(pos.m_7495_()))) {
            pos = pos.m_7495_();
        }
        Direction direction = this.rightDir.m_122424_();
        int j = this.computeWidth(pos, direction) - 1;
        return j < 0 ? null : pos.m_5484_(direction, j);
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BlockPos getBottomLeft() {
        return this.bottomLeft;
    }

    private int computeWidth() {
        int i = this.computeWidth(this.bottomLeft, this.rightDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int computeWidth(BlockPos pos, Direction direction) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutable.m_122190_((Vec3i)pos).m_122175_(direction, i);
            BlockState blockstate = this.world.m_8055_((BlockPos)blockpos$mutable);
            if (!VaultPortalSize.canConnect(blockstate)) {
                if (!this.positionPredicate.m_61035_(blockstate, (BlockGetter)this.world, (BlockPos)blockpos$mutable)) break;
                return i;
            }
            BlockState blockstate1 = this.world.m_8055_((BlockPos)blockpos$mutable.m_122173_(Direction.DOWN));
            if (!this.positionPredicate.m_61035_(blockstate1, (BlockGetter)this.world, (BlockPos)blockpos$mutable)) break;
        }
        return 0;
    }

    private int computeHeight() {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        int i = this.getFrameColumnCount(blockpos$mutable);
        return i >= 3 && i <= 21 && this.computeHeight(blockpos$mutable, i) ? i : 0;
    }

    private boolean computeHeight(BlockPos.MutableBlockPos mutablePos, int upDisplacement) {
        for (int i = 0; i < this.width; ++i) {
            BlockPos.MutableBlockPos blockpos$mutable = mutablePos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, upDisplacement).m_122175_(this.rightDir, i);
            if (this.positionPredicate.m_61035_(this.world.m_8055_((BlockPos)blockpos$mutable), (BlockGetter)this.world, (BlockPos)blockpos$mutable)) continue;
            return false;
        }
        return true;
    }

    private int getFrameColumnCount(BlockPos.MutableBlockPos mutablePos) {
        for (int i = 0; i < 21; ++i) {
            mutablePos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, -1);
            if (!this.positionPredicate.m_61035_(this.world.m_8055_((BlockPos)mutablePos), (BlockGetter)this.world, (BlockPos)mutablePos)) {
                return i;
            }
            mutablePos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, this.width);
            if (!this.positionPredicate.m_61035_(this.world.m_8055_((BlockPos)mutablePos), (BlockGetter)this.world, (BlockPos)mutablePos)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                mutablePos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, j);
                BlockState blockstate = this.world.m_8055_((BlockPos)mutablePos);
                if (!VaultPortalSize.canConnect(blockstate)) {
                    return i;
                }
                if (!blockstate.m_60713_((Block)ModBlocks.VAULT_PORTAL) && !blockstate.m_60713_((Block)ModBlocks.OTHER_SIDE_PORTAL)) continue;
                ++this.portalBlockCount;
            }
        }
        return 21;
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void placePortalBlocks(Consumer<BlockPos> placer) {
        BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(placer);
    }

    public boolean validatePortal() {
        return this.isValid() && this.portalBlockCount == this.width * this.height;
    }

    public Direction getRightDir() {
        return this.rightDir;
    }
}

